% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/fuzzy_w.R
\docType{class}
\name{FuzzUtils}
\alias{FuzzUtils}
\title{Utility functions}
\format{An object of class \code{R6ClassGenerator} of length 24.}
\usage{
# init <- FuzzUtils$new()
}
\arguments{
\item{string}{a character string.}

\item{string1}{a character string.}

\item{string2}{a character string.}

\item{input}{any kind of data type (applies to the \emph{Asciidammit} method)}

\item{force_ascii}{allow only ASCII characters (force convert to ascii)}

\item{n}{a float number}
}
\description{
Utility functions
}
\details{
the \emph{Full_process} processes a string by : 1. removing all but letters and numbers, 2. trim whitespace, 3. force to lower case and 4. if force_ascii == TRUE, force convert to ascii

the \emph{INTR} method returns a correctly rounded integer

the \emph{Make_type_consistent} method converts both objects if they aren't either both string or unicode instances to unicode

the \emph{Asciidammit} performs ascii dammit using the following expression \emph{bad_chars = str("").join([chr(i) for i in range(128, 256)])}. Applies to any kind of R data type.

the \emph{Asciionly} method returns the same result as the \emph{Asciidammit} method but for character strings using the python \emph{.translate()} function.

the \emph{Validate_string} method checks that the input has length and that length is greater than 0

Some of the utils functions are used as secondary methods in the \emph{FuzzExtract} class. See the examples of the \emph{FuzzExtract} class for more details.
}
\section{Methods}{


\describe{
 \item{\code{FuzzUtils$new()}}{}

 \item{\code{--------------}}{}

 \item{\code{Full_process(string = NULL, force_ascii = TRUE)}}{}

 \item{\code{--------------}}{}

 \item{\code{INTR(n = 2.0)}}{}

 \item{\code{--------------}}{}

 \item{\code{Make_type_consistent(string1 = NULL, string2 = NULL)}}{}

 \item{\code{--------------}}{}

 \item{\code{Asciidammit(input = NULL)}}{}

 \item{\code{--------------}}{}

 \item{\code{Asciionly(string = NULL)}}{}

 \item{\code{--------------}}{}

 \item{\code{Validate_string(string = NULL)}}{}
 }
}
\examples{

if (check_availability()) {


  library(fuzzywuzzyR)

  s1 = 'Frodo Baggins'

  s2 = 'Bilbo Baggin'

  init = FuzzUtils$new()

  init$Full_process(string = s1, force_ascii = TRUE)

  init$INTR(n = 2.0)

  init$Make_type_consistent(string1 = s1, string2 = s2)

  #------------------------------------
  # 'Asciidammit' with character string
  #------------------------------------

  init$Asciidammit(input = s1)

  #----------------------------------------------------------------
  # 'Asciidammit' with data.frame(123) [ or any kind of data type ]
  #----------------------------------------------------------------

  init$Asciidammit(input = data.frame(123))

  init$Asciionly(string = s1)

  init$Validate_string(string = s2)


}
}
\references{
https://github.com/seatgeek/fuzzywuzzy/blob/master/fuzzywuzzy/utils.py
}
\keyword{datasets}

