% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/fxTWAPLS.R
\name{cv.w}
\alias{cv.w}
\title{Leave-one-out cross-validation}
\usage{
cv.w(
  modern_taxa,
  modern_climate,
  nPLS = 5,
  trainfun,
  predictfun,
  usefx = FALSE,
  fx = NA,
  cpus = 4,
  test_mode = FALSE,
  test_it = 5
)
}
\arguments{
\item{modern_taxa}{the modern taxa abundance data, each row represents a
sampling site, each column represents a taxon.}

\item{modern_climate}{the modern climate value at each sampling site}

\item{nPLS}{the number of components to be extracted}

\item{trainfun}{training function you want to use, either
\code{\link{WAPLS.w}} or \code{\link{TWAPLS.w}}}

\item{predictfun}{predict function you want to use: if \code{trainfun} is
\code{\link{WAPLS.w}}, then this should be \code{\link{WAPLS.predict.w}};
if \code{trainfun} is \code{\link{TWAPLS.w}}, then this should be
\code{\link{TWAPLS.predict.w}}}

\item{usefx}{boolean flag on whether or not use \code{fx} correction.}

\item{fx}{the frequency of the climate value for \code{fx} correction: if
\code{usefx} is FALSE, this should be \code{NA}; otherwise, this should
be obtained from the \code{\link{fx}} function.}

\item{cpus}{number of CPUs for simultaneous iterations to execute, check
\code{parallel::detectCores()} for available CPUs on your machine.}

\item{test_mode}{boolean flag to execute the function with a limited number
of iterations, \code{test_it}, for testing purposes only.}

\item{test_it}{number of iterations to use in the test mode}
}
\value{
leave-one-out cross validation results
}
\description{
Leave-one-out cross-validation as
\code{rioja} (\url{https://cran.r-project.org/package=rioja})
}
\examples{
# Load modern pollen data
modern_pollen <- read.csv(system.file("extdata", 
                                      "Modern_Pollen_gdd_alpha_Tmin.csv", 
                                      package = "fxTWAPLS", 
                                      mustWork = TRUE))

# Extract taxa
taxaColMin <- which(colnames(modern_pollen) == "Abies")
taxaColMax <- which(colnames(modern_pollen) == "Zygophyllaceae")
taxa <- modern_pollen[, taxaColMin:taxaColMax]

# Get the frequency of each climate variable fx
fx_Tmin <- fxTWAPLS::fx(modern_pollen$Tmin, bin = 0.02)
fx_gdd <- fxTWAPLS::fx(modern_pollen$gdd, bin = 20)
fx_alpha <- fxTWAPLS::fx(modern_pollen$alpha, bin = 0.002)

# MTCO
## fx
fit_Tmin <- fxTWAPLS::WAPLS.w(taxa, modern_pollen$Tmin, nPLS = 5)
## LOOCV
test_mode <- TRUE # It should be set to FALSE before running
### without fx
cv_Tmin <- fxTWAPLS::cv.w(taxa,
                          modern_pollen$Tmin,
                          nPLS = 5,
                          fxTWAPLS::WAPLS.w,
                          fxTWAPLS::WAPLS.predict.w,
                          cpus = 2, # Remove the following line
                          test_mode = test_mode)
### with fx
cv_f_Tmin <- fxTWAPLS::cv.w(taxa,
                            modern_pollen$Tmin,
                            nPLS = 5,
                            fxTWAPLS::WAPLS.w,
                            fxTWAPLS::WAPLS.predict.w,
                            usefx = TRUE,
                            fx = fx_Tmin,
                            cpus = 2, # Remove the following line
                            test_mode = test_mode)  

}
\seealso{
\code{\link{fx}}, \code{\link{TWAPLS.w}},
\code{\link{TWAPLS.predict.w}}, \code{\link{WAPLS.w}}, and
\code{\link{WAPLS.predict.w}}
}
