% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/fxTWAPLS.R
\name{sse.sample}
\alias{sse.sample}
\title{Calculate Sample Specific Errors}
\usage{
sse.sample(
  modern_taxa,
  modern_climate,
  fossil_taxa,
  trainfun,
  predictfun,
  nboot,
  nPLS,
  nsig,
  usefx,
  fx,
  cpus = 4,
  seed = NULL,
  test_mode = FALSE,
  test_it = 5
)
}
\arguments{
\item{modern_taxa}{The modern taxa abundance data, each row represents a
sampling site, each column represents a taxon.}

\item{modern_climate}{The modern climate value at each sampling site}

\item{fossil_taxa}{Fossil taxa abundance data to reconstruct past climates,
each row represents a site to be reconstructed, each column represents a
taxon.}

\item{trainfun}{Training function you want to use, either
\code{\link{WAPLS.w}} or \code{\link{TWAPLS.w}}.}

\item{predictfun}{Predict function you want to use: if \code{trainfun} is
\code{\link{WAPLS.w}}, then this should be \code{\link{WAPLS.predict.w}};
if \code{trainfun} is \code{\link{TWAPLS.w}}, then this should be
\code{\link{TWAPLS.predict.w}}.}

\item{nboot}{The number of bootstrap cycles you want to use.}

\item{nPLS}{The number of components to be extracted.}

\item{nsig}{The significant number of components to use to reconstruct past
climates, this can be obtained from the cross-validation results.}

\item{usefx}{Boolean flag on whether or not use \code{fx} correction.}

\item{fx}{The frequency of the climate value for \code{fx} correction: if
\code{usefx = FALSE}, this should be \code{NA}; otherwise, this should
be obtained from the \code{\link{fx}} function.}

\item{cpus}{Number of CPUs for simultaneous iterations to execute, check
\code{parallel::detectCores()} for available CPUs on your machine.}

\item{seed}{Seed for reproducibility.}

\item{test_mode}{Boolean flag to execute the function with a limited number
of iterations, \code{test_it}, for testing purposes only.}

\item{test_it}{Number of iterations to use in the test mode.}
}
\value{
The bootstrapped standard error for each site.
}
\description{
Calculate Sample Specific Errors
}
\examples{
\dontrun{
# Load modern pollen data
modern_pollen <- read.csv("/path/to/modern_pollen.csv")
                                      
# Extract taxa
taxaColMin <- which(colnames(modern_pollen) == "taxa0")
taxaColMax <- which(colnames(modern_pollen) == "taxaN")
taxa <- modern_pollen[, taxaColMin:taxaColMax]

# Get the frequency of each climate variable fx
fx_Tmin <- fxTWAPLS::fx(modern_pollen$Tmin, bin = 0.02)
fx_gdd <- fxTWAPLS::fx(modern_pollen$gdd, bin = 20)
fx_alpha <- fxTWAPLS::fx(modern_pollen$alpha, bin = 0.002)

# Load reconstruction data
Holocene <- read.csv("/path/to/Holocene.csv")
taxaColMin <- which(colnames(Holocene) == "taxa0")
taxaColMax <- which(colnames(Holocene) == "taxaN")
core <- Holocene[, taxaColMin:taxaColMax]

# MTCO
## fx
fit_Tmin <- fxTWAPLS::WAPLS.w(taxa, modern_pollen$Tmin, nPLS = 5)
## SSE
nboot <- 5 # Recommended 1000
### without fx
sse_Tmin_WAPLS <- fxTWAPLS::sse.sample(modern_taxa = taxa,
                                       modern_climate = modern_pollen$Tmin,
                                       fossil_taxa = core,
                                       trainfun = fxTWAPLS::WAPLS.w,
                                       predictfun = 
                                         fxTWAPLS::WAPLS.predict.w,
                                       nboot = nboot,
                                       nPLS = 5,
                                       nsig = 3,
                                       usefx = FALSE,
                                       fx = NA,
                                       cpus = 2,
                                       seed = 1)
### with fx
sse_f_Tmin_WAPLS <- fxTWAPLS::sse.sample(modern_taxa = taxa,
                                         modern_climate = 
                                           modern_pollen$Tmin,
                                         fossil_taxa = core,
                                         trainfun = fxTWAPLS::WAPLS.w,
                                         predictfun = 
                                           fxTWAPLS::WAPLS.predict.w,
                                         nboot = nboot,
                                         nPLS = 5,
                                         nsig = 3,
                                         usefx = TRUE,
                                         fx = fx_Tmin,
                                         cpus = 2,
                                         seed = 1)
}

}
\seealso{
\code{\link{fx}}, \code{\link{TWAPLS.w}},
\code{\link{TWAPLS.predict.w}}, \code{\link{WAPLS.w}}, and
\code{\link{WAPLS.predict.w}}
}
