/*
 * Decompiled with CFR 0.152.
 */
package org.mutoss.gui.datatable;

import javax.swing.event.TableModelEvent;
import javax.swing.table.AbstractTableModel;
import org.mutoss.gui.datatable.CellValue;
import org.mutoss.gui.datatable.RDataFrameRef;
import org.mutoss.gui.datatable.RowModel;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DataTableModel
extends AbstractTableModel {
    protected RDataFrameRef df;
    private RowModel rowModel = null;

    public DataTableModel(RDataFrameRef df) {
        this.df = df;
    }

    @Override
    public int getColumnCount() {
        return this.df.getColumnCount();
    }

    @Override
    public int getRowCount() {
        return this.df.getRowCount();
    }

    @Override
    public String getColumnName(int col) {
        return this.df.getColName(col);
    }

    @Override
    public Class<?> getColumnClass(int col) {
        return CellValue.class;
    }

    @Override
    public boolean isCellEditable(int rowIndex, int col) {
        return rowIndex != col;
    }

    public void setValueAt(Double value, int row, int col) {
        this.getDataFrame().setValue(row, col, value);
        this.fireTableChanged(new TableModelEvent(this, row));
    }

    @Override
    public CellValue getValueAt(int row, int col) {
        return new CellValue(this.df.getElement(row, col));
    }

    public void addRowCol(String name) {
        this.df.addRowCol(name);
        this.fireTableRowsInserted(this.df.getColumnCount(), this.df.getColumnCount());
        this.fireTableStructureChanged();
    }

    public void delRowCol(int col) {
        this.df.delRowCol(col);
        this.fireTableStructureChanged();
    }

    public RDataFrameRef getDataFrame() {
        return this.df;
    }

    @Override
    public void fireTableStructureChanged() {
        super.fireTableStructureChanged();
        if (this.rowModel != null) {
            this.rowModel.fireTableStructureChanged();
        }
    }

    public void setRowModel(RowModel rowModel) {
        this.rowModel = rowModel;
    }
}

