/*
 * Decompiled with CFR 0.152.
 */
package org.mutoss.gui.options;

import com.jgoodies.forms.layout.CellConstraints;
import com.jgoodies.forms.layout.FormLayout;
import java.awt.Component;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Vector;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.LookAndFeel;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.UnsupportedLookAndFeelException;
import org.af.commons.Localizer;
import org.af.commons.widgets.WidgetFactory;
import org.af.commons.widgets.lists.IntegerJComboBox;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.mutoss.config.Configuration;
import org.mutoss.gui.options.OptionsDialog;
import org.mutoss.gui.options.OptionsPanel;
import org.mutoss.gui.options.SetLookAndFeelException;

public class GeneralPanel
extends OptionsPanel
implements ActionListener {
    private static final Log logger = LogFactory.getLog(GeneralPanel.class);
    private IntegerJComboBox cbFontSize;
    private JComboBox cbLookAndFeel;
    private JTextField jtfGrid;
    private JTextField jtfNumberOfDigits;
    private JTextField jtfLineWidth;
    private JTextField jtfEps;
    private Configuration conf = Configuration.getInstance();
    private OptionsDialog odialog;
    private JCheckBox colorImages;
    private JCheckBox showRejected;
    private JCheckBox showFractions;
    private JCheckBox useEpsApprox;
    private JCheckBox useJLaTeXMath;
    JFrame parent;

    public GeneralPanel(JFrame parent, OptionsDialog odialog) {
        this.odialog = odialog;
        this.parent = parent;
        this.makeComponents();
        this.doTheLayout();
    }

    private void makeComponents() {
        this.cbFontSize = new IntegerJComboBox(8, 20);
        this.cbFontSize.setSelectedObject((Object)this.conf.getGeneralConfig().getFontSize());
        this.jtfGrid = new JTextField(30);
        this.jtfGrid.setText("" + this.conf.getGeneralConfig().getGridSize());
        this.jtfNumberOfDigits = new JTextField(30);
        this.jtfNumberOfDigits.setText("" + this.conf.getGeneralConfig().getDigits());
        this.jtfLineWidth = new JTextField(30);
        this.jtfLineWidth.setText("" + this.conf.getGeneralConfig().getLineWidth());
        this.jtfEps = new JTextField(30);
        this.jtfEps.setText("" + this.conf.getGeneralConfig().getEpsilon());
        this.jtfEps.setEnabled(this.conf.getGeneralConfig().useEpsApprox());
        Vector<String> looknfeel = new Vector<String>();
        looknfeel.add("System");
        looknfeel.add("Windows");
        looknfeel.add("Mac OS");
        looknfeel.add("Motif");
        looknfeel.add("Metal");
        this.cbLookAndFeel = new JComboBox(looknfeel);
        logger.info((Object)("LooknFeel is " + this.conf.getJavaConfig().getLooknFeel() + "."));
        for (int i = 0; i < looknfeel.size(); ++i) {
            this.cbLookAndFeel.setSelectedIndex(i);
            if (this.getLooknFeel().equals(this.conf.getJavaConfig().getLooknFeel())) break;
            logger.debug((Object)("Not " + this.getLooknFeel()));
        }
        this.colorImages = new JCheckBox("Colored image files and pdf reports");
        this.colorImages.setSelected(this.conf.getGeneralConfig().getColoredImages());
        this.showFractions = new JCheckBox("Show fractions instead of decimal numbers");
        this.showFractions.setSelected(this.conf.getGeneralConfig().showFractions());
        this.showRejected = new JCheckBox("Show rejected nodes in GUI");
        this.showRejected.setSelected(this.conf.getGeneralConfig().showRejected());
        this.useJLaTeXMath = new JCheckBox("Use JLaTeXMath");
        this.useJLaTeXMath.setSelected(this.conf.getGeneralConfig().useJLaTeXMath());
        this.useEpsApprox = new JCheckBox("Use epsilon approximation");
        this.useEpsApprox.setSelected(this.conf.getGeneralConfig().useEpsApprox());
        this.useEpsApprox.addActionListener(this);
    }

    private void doTheLayout() {
        Localizer loc = Localizer.getInstance();
        JPanel p1 = new JPanel();
        String cols = "pref, 5dlu, fill:pref:grow";
        String rows = "pref, 5dlu, pref, 5dlu, pref, 5dlu, pref, 5dlu, pref, 5dlu, pref, 5dlu, pref, 5dlu, pref, 5dlu, pref, 5dlu, pref, 5dlu, pref, 5dlu, pref";
        FormLayout layout = new FormLayout(cols, rows);
        p1.setLayout((LayoutManager)layout);
        CellConstraints cc = new CellConstraints();
        int row = 1;
        p1.add((Component)new JLabel("Grid:"), cc.xy(1, row));
        p1.add((Component)this.jtfGrid, cc.xy(3, row));
        p1.add((Component)new JLabel("Number of digits:"), cc.xy(1, row += 2));
        p1.add((Component)this.jtfNumberOfDigits, cc.xy(3, row));
        p1.add((Component)new JLabel("Line width:"), cc.xy(1, row += 2));
        p1.add((Component)this.jtfLineWidth, cc.xy(3, row));
        p1.add((Component)this.useEpsApprox, cc.xyw(1, row += 2, 3));
        p1.add((Component)new JLabel("Epsilon:"), cc.xy(1, row += 2));
        p1.add((Component)this.jtfEps, cc.xy(3, row));
        p1.add((Component)new JLabel(loc.getString("SGTK_OPTIONS_GENERALPANEL_FONTSIZE")), cc.xy(1, row += 2));
        p1.add((Component)this.cbFontSize, cc.xy(3, row));
        p1.add((Component)new JLabel(loc.getString("SGTK_OPTIONS_GENERALPANEL_LF")), cc.xy(1, row += 2));
        p1.add((Component)this.cbLookAndFeel, cc.xy(3, row));
        p1.add((Component)this.colorImages, cc.xyw(1, row += 2, 3));
        p1.add((Component)this.showRejected, cc.xyw(1, row += 2, 3));
        p1.add((Component)this.useJLaTeXMath, cc.xyw(1, row += 2, 3));
        p1.add((Component)this.showFractions, cc.xyw(1, row += 2, 3));
        this.add(p1);
    }

    private String lfID2FullName(String id) {
        if (id.equals("Metal")) {
            return UIManager.getCrossPlatformLookAndFeelClassName();
        }
        if (id.equals("System")) {
            return UIManager.getSystemLookAndFeelClassName();
        }
        if (id.equals("Motif")) {
            return "com.sun.java.swing.plaf.motif.MotifLookAndFeel";
        }
        if (id.equals("Windows")) {
            return "com.sun.java.swing.plaf.windows.WindowsLookAndFeel";
        }
        if (id.equals("Mac OS")) {
            return "javax.swing.plaf.mac.MacLookAndFeel";
        }
        return null;
    }

    private String getLooknFeel() {
        String lf = this.lfID2FullName(this.cbLookAndFeel.getSelectedItem().toString());
        if (lf == null) {
            logger.warn((Object)"No LooknFeel selected! How can this be?");
        }
        return lf;
    }

    public void setProperties() throws SetLookAndFeelException {
        int fontSize = (Integer)this.cbFontSize.getSelectedObject();
        this.conf.getGeneralConfig().setFontSize(fontSize);
        try {
            int grid = Integer.parseInt(this.jtfGrid.getText());
            this.conf.getGeneralConfig().setGridSize(grid);
        }
        catch (NumberFormatException e) {
            JOptionPane.showMessageDialog(this, "\"" + this.jtfGrid.getText() + "\" is not a valid integer for grid size.", "Invalid input", 0);
        }
        try {
            int lw = Integer.parseInt(this.jtfLineWidth.getText());
            this.conf.getGeneralConfig().setLineWidth(lw);
        }
        catch (NumberFormatException e) {
            JOptionPane.showMessageDialog(this, "\"" + this.jtfLineWidth.getText() + "\" is not a valid integer for line width.", "Invalid input", 0);
        }
        try {
            int digits = Integer.parseInt(this.jtfNumberOfDigits.getText());
            this.conf.getGeneralConfig().setDigits(digits);
        }
        catch (NumberFormatException e) {
            JOptionPane.showMessageDialog(this, "\"" + this.jtfNumberOfDigits.getText() + "\" is not a valid integer for the number of digits.", "Invalid input", 0);
        }
        try {
            double eps = Double.parseDouble(this.jtfEps.getText());
            this.conf.getGeneralConfig().setEps(eps);
        }
        catch (NumberFormatException e) {
            JOptionPane.showMessageDialog(this, "\"" + this.jtfEps.getText() + "\" is not a valid double for epsilon.", "Invalid input", 0);
        }
        this.conf.getGeneralConfig().setColoredImages(this.colorImages.isSelected());
        this.conf.getGeneralConfig().setShowRejected(this.showRejected.isSelected());
        this.conf.getGeneralConfig().setShowFractions(this.showFractions.isSelected());
        this.conf.getGeneralConfig().setUseEpsApprox(this.useEpsApprox.isSelected());
        this.conf.getGeneralConfig().setUseJLaTeXMath(this.useJLaTeXMath.isSelected());
        try {
            LookAndFeel currentLF = UIManager.getLookAndFeel();
            logger.info((Object)("Selected LooknFeel:" + this.getLooknFeel()));
            this.setLooknFeel(this.getLooknFeel());
            if (!this.getLooknFeel().equals(this.conf.getJavaConfig().getLooknFeel())) {
                int n = JOptionPane.showConfirmDialog(this.parent, Localizer.getInstance().getString("SGTK_OPTIONS_GENERALPANEL_KEEPLF"), Localizer.getInstance().getString("SGTK_OPTIONS_GENERALPANEL_KEEPLF"), 0);
                if (n == 0) {
                    this.conf.getJavaConfig().setLooknFeel(this.getLooknFeel());
                } else {
                    this.setLooknFeel(currentLF);
                }
            }
        }
        catch (Exception exc) {
            JOptionPane.showMessageDialog(this.parent, "The selected LooknFeel is not available.", "Selected LooknFeel not available.", 2);
        }
    }

    private void setLooknFeel(String id) throws ClassNotFoundException, IllegalAccessException, InstantiationException, UnsupportedLookAndFeelException {
        UIManager.setLookAndFeel(id);
        WidgetFactory.setFontSizeGlobal((int)this.conf.getGeneralConfig().getFontSize());
        SwingUtilities.updateComponentTreeUI(this.parent);
        SwingUtilities.updateComponentTreeUI(this.odialog);
        this.odialog.pack();
    }

    private void setLooknFeel(LookAndFeel lf) throws ClassNotFoundException, IllegalAccessException, InstantiationException, UnsupportedLookAndFeelException {
        this.setLooknFeel(this.lfID2FullName(lf.getID()));
    }

    public void actionPerformed(ActionEvent e) {
        if (e.getSource() == this.useEpsApprox) {
            this.jtfEps.setEnabled(this.useEpsApprox.isSelected());
        }
    }
}

