/*
 * Decompiled with CFR 0.152.
 */
package org.af.gMCP.gui.datatable;

import java.awt.Dimension;
import javax.swing.JTable;
import org.af.gMCP.gui.datatable.DataTableModel;
import org.af.gMCP.gui.datatable.EpsilonTableCellRenderer;
import org.af.gMCP.gui.datatable.RDataFrameRef;
import org.af.gMCP.gui.graph.EdgeWeight;

public class DataTable
extends JTable {
    public DataTable(RDataFrameRef df) {
        this(new DataTableModel(df));
    }

    public DataTable(DataTableModel dataTableModel) {
        super(dataTableModel);
        this.getTableHeader().setReorderingAllowed(false);
        this.getColumnModel().setColumnSelectionAllowed(false);
        this.setRowSelectionAllowed(false);
        this.setAutoResizeMode(0);
        this.setDefaultRenderer(EdgeWeight.class, new EpsilonTableCellRenderer());
    }

    public DataTableModel getModel() {
        return (DataTableModel)super.getModel();
    }

    public void update() {
        this.getModel().fireTableStructureChanged();
    }

    public Dimension getPreferredScrollableViewportSize() {
        Dimension size = super.getPreferredScrollableViewportSize();
        return new Dimension(Math.min(this.getPreferredSize().width, size.width), size.height);
    }

    public boolean getScrollableTracksViewportWidth() {
        return this.getAutoResizeMode() == 0 ? this.getParent().getWidth() > this.getPreferredSize().width : super.getScrollableTracksViewportWidth();
    }

    public String getColumnVar(int col) {
        return this.getModel().getColumnName(col);
    }

    public void setTesting(boolean testing) {
        this.getModel().setTesting(testing);
    }
}

