/*
 * Decompiled with CFR 0.152.
 */
package org.af.gMCP.gui.options;

import com.jgoodies.forms.layout.CellConstraints;
import com.jgoodies.forms.layout.FormLayout;
import java.awt.Component;
import java.awt.LayoutManager;
import javax.swing.JCheckBox;
import javax.swing.JPanel;
import org.af.commons.widgets.validate.ValidationException;
import org.af.gMCP.config.Configuration;
import org.af.gMCP.gui.options.OptionsPanel;

public class MiscPanel
extends OptionsPanel {
    private JCheckBox checkOnlineForUpdate;
    private JCheckBox exportTransparent;
    private JCheckBox unanchorEdges;
    private JCheckBox focusEqualsEdit;
    private Configuration conf;

    public MiscPanel(Configuration conf) {
        this.conf = conf;
        this.makeComponents();
        this.doTheLayout();
    }

    private void makeComponents() {
        this.checkOnlineForUpdate = new JCheckBox("Check online for updates");
        this.checkOnlineForUpdate.setSelected(this.conf.getGeneralConfig().checkOnline());
        this.exportTransparent = new JCheckBox("Export images with transparent background");
        this.exportTransparent.setSelected(this.conf.getGeneralConfig().exportTransparent());
        this.unanchorEdges = new JCheckBox("Edge weights should adjust their position, whenever a node is dragged");
        this.unanchorEdges.setSelected(this.conf.getGeneralConfig().getUnAnchor());
        this.focusEqualsEdit = new JCheckBox("Automatically enter the editing mode, whenever a table cell gets the focus");
        this.focusEqualsEdit.setSelected(this.conf.getGeneralConfig().focusEqualsEdit());
    }

    private void doTheLayout() {
        JPanel p1 = new JPanel();
        String cols = "pref, 5dlu, fill:pref:grow";
        String rows = "pref, 5dlu, pref, 5dlu, pref, 5dlu, pref, 5dlu, pref, 5dlu, pref, 5dlu, pref, 5dlu, pref";
        FormLayout layout = new FormLayout(cols, rows);
        p1.setLayout((LayoutManager)layout);
        CellConstraints cc = new CellConstraints();
        int row = 1;
        p1.add((Component)this.checkOnlineForUpdate, cc.xyw(1, row, 3));
        p1.add((Component)this.exportTransparent, cc.xyw(1, row += 2, 3));
        p1.add((Component)this.unanchorEdges, cc.xyw(1, row += 2, 3));
        p1.add((Component)this.focusEqualsEdit, cc.xyw(1, row += 2, 3));
        row += 2;
        this.add(p1);
    }

    public void setProperties() throws ValidationException {
        this.conf.getGeneralConfig().setCheckOnline(this.checkOnlineForUpdate.isSelected());
        this.conf.getGeneralConfig().setExportTransparent(this.exportTransparent.isSelected());
        this.conf.getGeneralConfig().setUnAnchor(this.unanchorEdges.isSelected());
        this.conf.getGeneralConfig().setFocusEqualsEdit(this.focusEqualsEdit.isSelected());
    }
}

