% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot.R
\name{plotHull3D}
\alias{plotHull3D}
\title{Plot the convex hull of a set of points in 3D.}
\usage{
plotHull3D(
  pts,
  drawPoints = FALSE,
  drawLines = TRUE,
  drawPolygons = TRUE,
  addText = FALSE,
  addRays = FALSE,
  useRGLBBox = TRUE,
  direction = 1,
  drawBBoxHull = TRUE,
  ...
)
}
\arguments{
\item{pts}{A matrix with a point in each row.}

\item{drawPoints}{Draw the points.}

\item{drawLines}{Draw lines of the facets.}

\item{drawPolygons}{Fill the facets.}

\item{addText}{Add text to the points. Currently \code{coord} (coordinates), \code{rownames} (rownames)
and \code{both} supported or a vector with text.}

\item{addRays}{Add the ray defined by \code{direction}.}

\item{useRGLBBox}{Use the RGL bounding box when add rays.}

\item{direction}{Ray direction. If i'th entry is positive, consider the i'th column of \code{pts}
plus a value greater than on equal zero (minimize objective $i$). If negative, consider the
i'th column of \code{pts} minus a value greater than on equal zero (maximize objective $i$).}

\item{drawBBoxHull}{If addRays then draw the hull areas hitting the bounding box also.}

\item{...}{Further arguments passed on the the RGL plotting functions. This must be done as
lists (see examples). Currently the following arguments are supported:
\itemize{
\item \code{argsPlot3d}: A list of arguments for \code{\link[rgl:plot3d]{rgl::plot3d}}.
\item \code{argsSegments3d}: A list of arguments for \code{\link[rgl:3dobjects]{rgl::segments3d}}.
\item \code{argsPolygon3d}: A list of arguments for \code{\link[rgl:polygon3d]{rgl::polygon3d}}.
\item \code{argsShade3d}: A list of arguments for \code{\link[rgl:mesh3d]{rgl::shade3d}}.
\item \code{argsText3d}: A list of arguments for \code{\link[rgl:texts]{rgl::text3d}}.
}}
}
\value{
A list with hull, \code{pts} classified and object ids (invisible).
}
\description{
Plot the convex hull of a set of points in 3D.
}
\examples{
\donttest{
ini3D()
pts<-matrix(c(0,0,0), ncol = 3, byrow = TRUE)
plotHull3D(pts) # a point
pts<-matrix(c(1,1,1,2,2,2,3,3,3), ncol = 3, byrow = TRUE)
plotHull3D(pts, drawPoints = TRUE) # a line
pts<-matrix(c(1,0,0,1,1,1,1,2,2,3,1,1,3,3,3), ncol = 3, byrow = TRUE)
plotHull3D(pts, drawLines = FALSE, argsPolygon3d = list(alpha=0.6)) # a polygon
pts<-matrix(c(5,5,5,10,10,5,10,5,5,5,5,10), ncol = 3, byrow = TRUE)
lst <- plotHull3D(pts, argsPolygon3d = list(alpha=0.9), argsSegments3d = list(color="red"))
finalize3D()
# rgl.pop(id = lst$ids) # remove last hull

## Using addRays
pts <- data.frame(x = c(1,3), y = c(1,3), z = c(1,3))
ini3D(argsPlot3d = list(xlim = c(0,max(pts$x)+10),
  ylim = c(0,max(pts$y)+10),
  zlim = c(0,max(pts$z)+10)))
plotHull3D(pts, drawPoints = TRUE, addRays = TRUE, , drawBBoxHull = FALSE)
plotHull3D(c(4,4,4), drawPoints = TRUE, addRays = TRUE)
finalize3D()

pts <- data.frame(x = c(4,2.5,1), y = c(1,2.5,4), z = c(1,2.5,4))
ini3D(argsPlot3d = list(xlim = c(0,max(pts$x)+10),
  ylim = c(0,max(pts$y)+10),
  zlim = c(0,max(pts$z)+10)))
plotHull3D(pts, drawPoints = TRUE, addRays = TRUE)
finalize3D()

pts <- matrix(c(
  0, 4, 8,
  0, 8, 4,
  8, 4, 0,
  4, 8, 0,
  4, 0, 8,
  8, 0, 4,
  4, 4, 4,
  6, 6, 6
  ), ncol = 3, byrow = TRUE)
ini3D(FALSE, argsPlot3d = list(xlim = c(min(pts[,1])-2,max(pts[,1])+10),
  ylim = c(min(pts[,2])-2,max(pts[,2])+10),
  zlim = c(min(pts[,3])-2,max(pts[,3])+10)))
plotHull3D(pts, drawPoints = TRUE, addText = "coord")
plotHull3D(pts, addRays = TRUE)
finalize3D()

pts <- genNDSet(3, 100, dubND = FALSE)
pts <- as.data.frame(pts[,1:3])

ini3D(argsPlot3d = list(
  xlim = c(0,max(pts[,1])+10),
  ylim = c(0,max(pts[,2])+10),
  zlim = c(0,max(pts[,3])+10)))
plotHull3D(pts, drawPoints = TRUE, addRays = TRUE)
finalize3D()

ini3D(argsPlot3d = list(
  xlim = c(0,max(pts[,1])+10),
  ylim = c(0,max(pts[,2])+10),
  zlim = c(0,max(pts[,3])+10)))
plotHull3D(pts, drawPoints = TRUE, drawPolygons = TRUE, addText = "coord", addRays = TRUE)
finalize3D()

ini3D(argsPlot3d = list(
  xlim = c(0,max(pts[,1])+10),
  ylim = c(0,max(pts[,2])+10),
  zlim = c(0,max(pts[,3])+10)))
plotHull3D(pts, drawPoints = TRUE, drawLines = FALSE,
  argsPolygon3d = list(alpha = 1), addRays = TRUE)
finalize3D()

ini3D(argsPlot3d = list(
  xlim = c(0,max(pts[,1])+10),
  ylim = c(0,max(pts[,2])+10),
  zlim = c(0,max(pts[,3])+10)))
plotHull3D(pts, drawPoints = TRUE, argsPolygon3d = list(color = "red"), addRays = TRUE)
plotCones3D(pts, argsPolygon3d = list(alpha = 1), rectangle = TRUE)
finalize3D()
}
}
