% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/t_array-operations.R
\name{array-operations}
\alias{aperm__}
\alias{arEqual}
\alias{arExt}
\alias{arPerm}
\alias{arSlice}
\alias{arSliceMult}
\alias{arSlicePrim}
\alias{aralign}
\alias{arequal}
\alias{arexpand}
\alias{armarg}
\alias{arperm}
\alias{array-operations}
\alias{tabAdd__}
\alias{tabAlign}
\alias{tabAlign__}
\alias{tabCondProb}
\alias{tabDiv0__}
\alias{tabDiv__}
\alias{tabEqual}
\alias{tabEqual__}
\alias{tabExpand}
\alias{tabExpand__}
\alias{tabExt}
\alias{tabListAdd}
\alias{tabListAdd__}
\alias{tabListMult}
\alias{tabListMult__}
\alias{tabMarg}
\alias{tabMarg__}
\alias{tabMult__}
\alias{tabOp__}
\alias{tabPerm}
\alias{tabPerm__}
\alias{tabSlice}
\alias{tabSlice2}
\alias{tabSlice2Entries}
\alias{tabSlice2Entries_}
\alias{tabSliceMult}
\alias{tabSlicePrim}
\alias{tabSubt__}
\title{Operations on multidimensional arrays.}
\usage{
arperm(tab, perm)

armarg(tab, marg)

arequal(tab1, tab2, eps = 1e-12)

arexpand(tab1, tab2)

aralign(tab1, tab2)
}
\arguments{
\item{tab, tab1, tab2}{Multidimensional arrays.}

\item{perm}{A vector of indices or dimnames giving the desired permutiation.}

\item{marg}{Specification of marginal; either a character vector, a numeric
vector or a right hand sided formula For \code{arperm} and \code{ararg}
it can also be a right hand sided formula.}

\item{eps}{Criterion for checking equality of two arrays.}
}
\value{
Most functions here return a multidimensional array.
}
\description{
Operations like marginalize, permute, slicing etc on
    arrays A multidimensional table (an array) is here a vector
    with a dim and a dimnames attribute.
}
\details{
\code{perm} in \code{arperm()} can be a vector of indices
    (as in Rs own \code{aperm()}) but also a vector of
    dimnames. Currently there is no checking that the dimnames are
    actually in the array, so please take care.
}
\examples{

ar1 <- array(1:8, dim=c(2,2,2), dimnames=list("a"=1:2,"b"=1:2,"c"=1:2))
ar2 <- array(1:8, dim=c(2,2,2), dimnames=list("b"=1:2,"c"=1:2,"d"=1:2))

## ## armarg ##
## Marginalize down to the bc-array
armarg(ar1, 2:3)
armarg(ar1, c("b","c"))
armarg(ar1, ~b + c)

## This gives an error
## armarg(ar1, c(2,5))
## armarg(ar1, c("b","w"))
## armarg(ar1, ~b + w)
 
## ## arperm ##
arperm(ar1, 1:3)      ## No change - an abc-table
arperm(ar1, c(2,3,1)) ## A bca-table
arperm(ar1, ~b + c + a)

## This gives error
## arperm(ar1, c(2,1))
## arperm(ar1, c(2,1,5))
## arperm(ar1, c(2,1,NA))

## ## armult etc ##
## Multiply two arrays
out <- armult(ar1, ar2)
out <- arperm(out, ~a+b+c+d) ## Just for comparison below
ftable(out)
## Alternative approch
df1 <- as.data.frame.table(ar1)
df2 <- as.data.frame.table(ar2)
df3 <- merge(df1, df2, by=c("b","c"))
df3 <- transform(df3, Freq=Freq.x*Freq.y)
ar3 <- xtabs(Freq ~ a + b + c + d, data=df3)
ftable(ar3)

## ## arexpand ##
ar1.e <- arexpand(ar1, ar2)
## ar1.e has dimnames b,c,d,a; values are simply replicated for each
## level of d.
dimnames(ar1.e)
ftable(ar1.e, row.vars="d")

## ## aralign ##
ar2.e <- arexpand(ar2, ar1)
names(dimnames(ar2.e))
names(dimnames(ar1.e))
out <- aralign(ar1.e, ar2.e)
names(dimnames(out)) ## Same as ar2.e

## arexpand:
ar1 <- array(1:8, dim=c(2,2,2), dimnames=list("a"=1:2,"b"=1:2,"c"=1:2))
ar2 <- array(1:8, dim=c(2,2,2), dimnames=list("b"=1:2,"c"=1:2,"d"=1:2))

arexpand(ar1, ar2) \%>\% ftable(row.vars=1) ## Same as
## arexpand(ar1, dimnames(ar2)) \%>\% ftable(row.vars=1) 
}
\author{
Søren Højsgaard, \email{sorenh@math.aau.dk}
}
\seealso{
\code{\link{aperm}}, \code{\link{arslice}},
    \code{\link{arslice_entries}}
}
\keyword{utilities}

