% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/gRbase-utilities.R
\name{gRbase_utilities}
\alias{gRbase_utilities}
\alias{rhsFormula2list}
\alias{matrix2list}
\alias{rowmat2list}
\alias{colmat2list}
\alias{rhsf2list}
\alias{list2rhsFormula}
\alias{list2rhsf}
\alias{which.arr.index}
\alias{which_matrix_index}
\alias{rowSumsPrim}
\alias{colSumsPrim}
\alias{colwiseProd}
\title{gRbase utilities}
\usage{
rhsFormula2list(f)

rhsf2list(f)

list2rhsFormula(f)

list2rhsf(f)

rowmat2list(XX_)

colmat2list(XX_)

matrix2list(XX_, byrow = TRUE)

which.arr.index(XX_)

which_matrix_index(XX_)

rowSumsPrim(XX_)

colSumsPrim(XX_)

colwiseProd(v, M)
}
\arguments{
\item{f}{Formula specification (a right-hand sided formula, a
numeric/character vector or a list of vectors).}

\item{XX_}{A matrix.}

\item{byrow}{Should the split be by row or by column.}

\item{v}{A vector.}

\item{M}{A matrix.}
}
\description{
Various utility functions for gRbase. Includes 'faster
    versions' of certain standard R functions.
}
\details{
\code{which.arr.ind}: Returns matrix n x 2 matrix with
    indices of non-zero entries in matrix \code{XX_}. Notice
    \code{which_matrix_index__} is cpp implementation.

\code{colwiseProd}: multiplies a vector v and a matrix M
    columnwise (as opposed to rowwise which is achieved by
    \code{v * M}). Hence \code{colwiseProd} does the same as
    \code{t(v * t(M))} - but it does so faster for numeric values.
}
\examples{
## colwiseProd
M <- matrix(1:16, nrow=4)
v <- 1:4
t(v * t(M))
colwiseProd(v, M)
\dontrun{
system.time(for (ii in 1:100000)  t(v * t(M)))
system.time(for (ii in 1:100000)  colwiseProd(v, M))
}

}
\author{
Søren Højsgaard, \email{sorenh@math.aau.dk}
}
