% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/api_array_cell.R
\name{api-cell}
\alias{api-cell}
\alias{cell2entry}
\alias{entry2cell}
\alias{next_cell}
\alias{next_cell_slice}
\alias{slice2entry}
\alias{cell2entry_perm}
\alias{perm_cell_entries}
\alias{fact_grid}
\title{Table cell operations.}
\usage{
cell2entry(cell, dim)

entry2cell(entry, dim)

next_cell(cell, dim)

next_cell_slice(cell, dim, slice_marg)

slice2entry(slice_cell, slice_marg, dim)

cell2entry_perm(cell, dim, perm)

perm_cell_entries(perm, dim)

fact_grid(dim, slice_cell = NULL, slice_marg = NULL)
}
\arguments{
\item{cell}{Vector giving the cell, e.g. c(1, 1, 2) in 3-way table.}

\item{dim}{Vector giving array dimension, eg c(2, 2, 2).}

\item{entry}{An entry in an array (a number indexing a vector).}

\item{slice_marg}{Vector giving the margin of a table, eg. c(2, 3)}

\item{slice_cell}{Vector giving the corresponding cell of marginal
table, e.g. c(1, 2)}

\item{perm}{Vector giving permutaion of array, eg. c(1, 3, 2).}
}
\description{
Low level table cell operations.
}
\examples{

di <- c(2, 2, 3)

cell2entry(c(1, 1, 1), dim=di)
cell2entry(c(2, 2, 3), dim=di)

entry2cell(1, dim=di)
entry2cell(12, dim=di)

next_cell(c(1, 1, 1), dim=di)
next_cell(c(2, 1, 1), dim=di)

## The first two entries are kept fixed
next_cell_slice(c(2, 1, 1), dim=di, slice_marg=c(1, 2))
next_cell_slice(c(2, 1, 2), dim=di, slice_marg=c(1, 2))

## Cell (2, 2, 1) corresponds to entry 4
cell2entry(c(2, 2, 1), dim=di)
## Same as
cell2entry_perm(c(2, 2, 1), dim=di, perm=c(1, 2, 3))
## If the table dimensions are permuted as (3, 1, 2)
## the entry becomes
cell2entry_perm(c(2, 2, 1), dim=di, perm=c(3, 1, 2))
}
