% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/galah_group_by.R
\name{galah_group_by}
\alias{galah_group_by}
\title{Specify fields to group when downloading record counts}
\usage{
galah_group_by(..., expand = TRUE)
}
\arguments{
\item{...}{zero or more individual column names to include}

\item{expand}{\code{logical}: When passed to \code{group_by} argument of
\code{atlas_counts}, should factor levels be expanded? Defaults to \code{TRUE}.}
}
\value{
If any arguments are provided, returns a \code{data.frame} with
columns \code{name} and \code{type}, as per \code{\link[=galah_select]{galah_select()}}; if no arguments
are provided, returns \code{NULL}.
}
\description{
\code{atlas_counts} supports server-side grouping of data. Grouping can be
used to return record counts grouped by multiple, valid fields (found by
\code{search_fields}. Use \code{galah_group_by} when using the
\code{group_by} argument of \code{atlas_counts} to return record counts summed
by one or more valid fields.
}
\section{Examples}{


Return record counts since 2010 by year\if{html}{\out{<div class="sourceCode r">}}\preformatted{records <- galah_call() |> 
    galah_filter(year > 2010) |>
    galah_group_by(year) |>
    atlas_counts()
}\if{html}{\out{</div>}}\if{html}{\out{<div class="sourceCode r">}}\preformatted{records
#> # A tibble: 12 x 2
#>    year    count
#>    <chr>   <int>
#>  1 2020  5843340
#>  2 2019  5506924
#>  3 2018  5418009
#>  4 2017  4648403
#>  5 2016  3844787
#>  6 2014  3767573
#>  7 2015  3605917
#>  8 2013  3505658
#>  9 2012  2933981
#> 10 2011  2539004
#> 11 2021  1161557
#> 12 2022    41790
}\if{html}{\out{</div>}}

Return record counts since 2010 by year and data provider\if{html}{\out{<div class="sourceCode r">}}\preformatted{records <- galah_call() |>
    galah_filter(year > 2010) |>
    galah_group_by(year, dataResourceName) |>
    atlas_counts()
}\if{html}{\out{</div>}}\if{html}{\out{<div class="sourceCode r">}}\preformatted{records
#> # A tibble: 1,048 x 3
#>   year  dataResourceName              count
#>   <chr> <chr>                         <int>
#> 1 2020  eBird Australia             4589800
#> 2 2020  iNaturalist Australia        671032
#> 3 2020  NSW BioNet Atlas             372617
#> 4 2020  Earth Guardians Weekly Feed   71783
#> # ... with 1,044 more rows
}\if{html}{\out{</div>}}

Return record counts of \emph{Litoria} species each year since 2015, limiting
results to the top 5 each year\if{html}{\out{<div class="sourceCode r">}}\preformatted{records <- galah_call() |>
    galah_identify("Litoria") |>
    galah_filter(year > 2015) |>
    galah_group_by(year, species) |>
    atlas_counts(limit = 5)
}\if{html}{\out{</div>}}\if{html}{\out{<div class="sourceCode r">}}\preformatted{records
#> # A tibble: 35 x 3
#>   year  species            count
#>   <chr> <chr>              <int>
#> 1 2018  Litoria peronii    10497
#> 2 2018  Litoria fallax      7013
#> 3 2018  Litoria caerulea    3073
#> 4 2018  Litoria verreauxii  2980
#> # ... with 31 more rows
}\if{html}{\out{</div>}}
}

\seealso{
\code{\link[=galah_select]{galah_select()}}, \code{\link[=galah_filter]{galah_filter()}} and
\code{\link[=galah_geolocate]{galah_geolocate()}} for related methods.
}
