% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/galah_group_by.R
\name{group_by.data_request}
\alias{group_by.data_request}
\alias{galah_group_by}
\title{Group by one or more variables}
\usage{
\method{group_by}{data_request}(.data, ...)

galah_group_by(...)
}
\arguments{
\item{.data}{An object of class \code{data_request}}

\item{...}{Zero or more individual column names to include}
}
\value{
If any arguments are provided, returns a \code{data.frame} with
columns \code{name} and \code{type}, as per \code{\link[=select.data_request]{select.data_request()}}.
}
\description{
Most data operations are done on groups defined by variables. \code{group_by()}
takes a query and adds a grouping variable that can be used in combination
with \code{\link[=count.data_request]{count()}} to give information on number
of occurrences per level of that variable.
}
\examples{
\dontrun{
galah_call() |> 
  group_by(basisOfRecord) |>
  counts() |>
  collect()
}
}
