% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/residuals.galamm.R
\name{residuals.galamm}
\alias{residuals.galamm}
\title{Residuals of galamm objects}
\usage{
\method{residuals}{galamm}(object, type = c("pearson", "deviance"), ...)
}
\arguments{
\item{object}{An object of class \code{galamm} returned from
\code{\link{galamm}}.}

\item{type}{Character of length one describing the type of residuals to be
returned. One of \code{"pearson"} and \code{"deviance"}. Argument is case
sensitive.}

\item{...}{Optional arguments passed on to other methods. Currently not used.}
}
\value{
Numeric vector of residual values.
}
\description{
Residuals of galamm objects
}
\examples{
# Poisson GLMM
count_mod <- galamm(
  formula = y ~ lbas * treat + lage + v4 + (1 | subj),
  data = epilep, family = poisson
)

# Extract residuals
residuals(count_mod)

}
\seealso{
\code{\link[=fitted.galamm]{fitted.galamm()}} for model fitted values, \code{\link[=predict.galamm]{predict.galamm()}} for
model predictions, and \code{\link[=plot.galamm]{plot.galamm()}} for diagnostic plots. The generic
function is \code{\link[=residuals]{residuals()}}.

Other details of model fit: 
\code{\link{VarCorr}()},
\code{\link{coef.galamm}()},
\code{\link{confint.galamm}()},
\code{\link{deviance.galamm}()},
\code{\link{factor_loadings.galamm}()},
\code{\link{family.galamm}()},
\code{\link{fitted.galamm}()},
\code{\link{fixef}()},
\code{\link{formula.galamm}()},
\code{\link{llikAIC}()},
\code{\link{logLik.galamm}()},
\code{\link{nobs.galamm}()},
\code{\link{predict.galamm}()},
\code{\link{print.VarCorr.galamm}()},
\code{\link{ranef.galamm}()},
\code{\link{sigma.galamm}()},
\code{\link{vcov.galamm}()}
}
\concept{details of model fit}
