% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/AllClasses.R
\docType{class}
\name{CalibrationCurve-class}
\alias{CalibrationCurve-class}
\alias{DoseRateModel-class}
\alias{.DoseRateModel}
\alias{.CalibrationCurve}
\title{An S4 class to Represent a Dose Rate Calibration Curve}
\description{
An S4 class to Represent a Dose Rate Calibration Curve
}
\section{Slots}{

\describe{
\item{\code{Ni}}{A \linkS4class{DoseRateModel} object.}

\item{\code{NiEi}}{A \linkS4class{DoseRateModel} object.}

\item{\code{details}}{A \code{\link{list}} of length-one vector giving the curve metadata.}

\item{\code{slope}}{A \code{\link{numeric}} vector.}

\item{\code{intercept}}{A \code{\link{numeric}} vector.}

\item{\code{covariance}}{A \code{\link{numeric}} vector.}

\item{\code{MSWD}}{A \code{\link{numeric}} vector.}

\item{\code{df}}{A \code{\link{numeric}} vector.}

\item{\code{p_value}}{A \code{\link{numeric}} vector.}

\item{\code{data}}{A \code{\link{data.frame}}.}

\item{\code{range}}{A \code{\link{numeric}} vector.}

\item{\code{background}}{A \code{\link{numeric}} vector.}
}}

\section{Subset}{

In the code snippets below, \code{x} is a \code{CalibrationCurve} object.
\describe{
\item{\code{x[[i]]}}{Extracts information from a slot selected by subscript \code{i}.
\code{i} is a \code{character} vector of length one.}
}
}

\seealso{
Other class: 
\code{\link{Baseline-class}},
\code{\link{GammaSpectra-class}},
\code{\link{GammaSpectrum-class}},
\code{\link{PeakPosition-class}},
\code{\link{coerce}()}
}
\author{
N. Frerebeau
}
\concept{class}
