% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/credentials_user_oauth2.R
\name{credentials_user_oauth2}
\alias{credentials_user_oauth2}
\title{Get an OAuth token for a user}
\usage{
credentials_user_oauth2(scopes = NULL, app = gargle_app(),
  package = "gargle", ...)
}
\arguments{
\item{scopes}{A character vector of scopes to request. Pick from those listed
in \href{https://developers.google.com/identity/protocols/googlescopes}{OAuth 2.0 Scopes for Google APIs}.

For certain token flows, the
\code{"https://www.googleapis.com/auth/userinfo.email"} scope is unconditionally
included. This grants permission to retrieve the email address associated
with a token; gargle uses this to index cached OAuth tokens. This grants no
permission to view or send email. It is considered a low value scope and
does not appear on the consent screen.}

\item{app}{An OAuth consumer application, created by \code{\link[httr:oauth_app]{httr::oauth_app()}}.}

\item{package}{Name of the package requesting a token. Used in messages.}

\item{...}{Arguments passed on to \code{gargle2.0_token}
\describe{
  \item{email}{Optional. Allows user to target a specific Google identity. If
specified, this is used for token lookup, i.e. to determine if a suitable
token is already available in the cache. If no such token is found, \code{email}
is used to pre-select the targetted Google identity in the OAuth chooser.
Note, however, that the email associated with a token when it's cached is
always determined from the token itself, never from this argument. Use \code{NA}
or \code{FALSE} to match nothing and force the OAuth dance in the browser. Use
\code{TRUE} to allow email auto-discovery, if exactly one matching token is
found in the cache. Defaults to the option named "gargle_oauth_email",
retrieved by \code{\link[=gargle_oauth_email]{gargle_oauth_email()}}.}
  \item{use_oob}{Whether to prefer "out of band" authentication. Defaults to
the option named "gargle_oob_default", retrieved via
\code{\link[=gargle_oob_default]{gargle_oob_default()}}.}
  \item{cache}{Specifies the OAuth token cache. Defaults to the option named
"gargle_oauth_cache", retrieved via \code{\link[=gargle_oauth_cache]{gargle_oauth_cache()}}.}
  \item{user_params}{Named list holding endpoint specific parameters to pass to
the server when posting the request for obtaining or refreshing the
access token.}
  \item{type}{content type used to override incorrect server response}
  \item{credentials}{Advanced use only: allows you to completely customise
token generation.}
}}
}
\value{
A \link{Gargle2.0} token.
}
\description{
Consults the token cache for a suitable OAuth token and, if
unsuccessful, gets a token via the browser flow. A cached token is suitable
if it's compatible with the user's request in this sense:
\itemize{
\item OAuth app must be same.
\item Scopes must be same.
\item Email, if provided, must be same.
}

gargle is very conservative about using OAuth tokens discovered in the user's
cache and will generally seek interactive confirmation. Therefore, in a
non-interactive setting, it's important to explicitly specify the \code{"email"}
of the target account or to explicitly authorize automatic discovery. See
\code{\link[=gargle2.0_token]{gargle2.0_token()}}, which this function wraps, for more. Non-interactive use
also suggests it might be time to use a \link[=credentials_service_account]{service account token}.
}
\examples{
\dontrun{
## Drive scope, built-in gargle demo app
scopes <- "https://www.googleapis.com/auth/drive"
credentials_user_oauth2(scopes, app = gargle_app())

## bring your own app
app <- httr::oauth_app(
  appname = "my_awesome_app",
  key = "keykeykeykeykeykey",
  secret = "secretsecretsecret"
)
credentials_user_oauth2(scopes, app)
}
}
\seealso{
Other credential functions: \code{\link{credentials_app_default}},
  \code{\link{credentials_gce}},
  \code{\link{credentials_service_account}},
  \code{\link{token_fetch}}
}
\concept{credential functions}
