% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/get_gbif.R
\name{get_gbif}
\alias{get_gbif}
\title{Used in gators_download() - Download data from the Global Biodiversity Information Facility}
\usage{
get_gbif(synonyms.list, gbif.match = "fuzzy", gbif.prov = FALSE, limit = 1e+05)
}
\arguments{
\item{synonyms.list}{A list of affiliated names for your query.}

\item{gbif.match}{Default = "fuzzy". Either "fuzzy" for fuzzy matching of name or "code" to search by species code.}

\item{gbif.prov}{Default = FALSE. A parameter to obtain the provider/verbatim columns from GBIF.}

\item{limit}{Default = 100,000 (maximum). Set limit to the number of records requested for each element in synonyms.list.}
}
\value{
Returns a data frame with desired columns from GBIF.
}
\description{
The \code{get_gbif()} function queries the Global Biodiversity Information Facility (GBIF) for your desired species.
Limited to 100,000 record downloads.
}
\details{
This function uses the \code{correct_class()} function.
This function requires the packages rgbif, magrittr, and dplyr.
}
\examples{
df <- get_gbif(c("Galax urceolata", "Galax aphylla"), limit = 5)
df <- get_gbif(c("Galax urceolata", "Galax aphylla"),
gbif.match = "code", limit = 5)
df <- get_gbif(c("Galax urceolata", "Galax aphylla"), gbif.prov = TRUE, limit = 5)

}
