% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/frobstepwise.R
\name{frobstepwise}
\alias{frobstepwise}
\title{robust stepwise selection of covariates}
\usage{
frobstepwise(y, x, cn, alpha, nu = 1, kmax = 0, intercept = TRUE,
  chkintercept = FALSE, kexk = 0, sig = 0)
}
\arguments{
\item{y}{Dependent variable}

\item{x}{Covariates}

\item{cn}{Parameter fir Huber's psi-function}

\item{alpha}{The P-value cut-off}

\item{nu}{The order statistic of Gaussian covariates used for comparison}

\item{kmax}{The maximum number of included covariates}

\item{intercept}{Logical to include intercept}

\item{chkintercept}{Logical to include or exclude intercept dependent on the P-value}

\item{kexk}{The excluded covariates}

\item{sig}{Scale value of dependent variable}

}
\value{
pv pv[[1]] the included covariates, the P-values; pv[[2]] coefficients of robust linear regression; pv[[3]]  residuals; pv[[4]] scale.
}
\description{
robust stepwise selection of covariates
}
\examples{
data(gausscov)
bostonrob<-frobstepwise(boston[,14],boston[,1:13],1,0.01,15,intercept=TRUE)
bostonrob[[1]]
bostonrob[[2]]
plot(bostonrob[[3]])
}
