% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/autofit_gaussian_2D.R
\name{autofit_gaussian_2D}
\alias{autofit_gaussian_2D}
\title{Automatically determine the best-fitting 2D Gaussian for a data set}
\usage{
autofit_gaussian_2D(
  data,
  comparison_method = "rmse",
  maxiter = 1000,
  simplify = TRUE
)
}
\arguments{
\item{data}{A data.frame that contains the raw data (generally rectilinearly
gridded data, but this is not a strict requirement). Columns must be named
\code{"X_values"}, \code{"Y_values"} and \code{"response"}.}

\item{comparison_method}{One of "rmse", "rss", or "AIC"; what metric should
be used to determine the "best-fitting" Gaussian?}

\item{maxiter}{Default 1000. A positive integer specifying the maximum number
of iterations allowed. See \code{stats::nls.control()} for more details.}

\item{simplify}{TRUE or FALSE. If TRUE, return only the coefficients, model,
model_error_stats, and fit_method for the best-fitting model. If FALSE, a
model comparison table is also included in the returned list as
\code{$model_comparison}. This table is obtained via
\code{compare_gaussian_fits()}.}
}
\value{
If \code{simplify = TRUE}, a list with the components:
\itemize{
\item{"coefs"} {A data.frame of fitted model parameters.}
\item{"model"} {The model object, fitted by \code{stats::nls()}.}
\item{"model_error_stats"} {A data.frame detailing the rss, rmse, deviance,
and AIC of the fitted model.}
\item{"fit_method"} {A character vector that indicates which method and
orientation strategy was used by this function.}
}

If \code{simplify = FALSE}, a model comparison table is also included
in the returned list as \code{$model_comparison}. This table is obtained
via \code{compare_gaussian_fits()}.
}
\description{
Automatically determine the best-fitting 2D Gaussian for a data set
}
\details{
This function runs \code{fit_gaussian_2D()} three times: once for
each of the "main" types of models: 1) elliptical, unconstrained; 2)
elliptical, log; 3) circular. In all three cases, amplitudes and
orientations are unconstrained. The function \code{compare_gaussian_fits()}
is then used to determine which of these three models is the best-fitting,
using the \code{comparison_method} argument to make the decision.
}
\examples{
if (interactive()) {
}
}
\author{
Vikram B. Baliga
}
