% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/get_static_feeds.R
\name{get_station_information}
\alias{get_station_information}
\title{Save the station_information feed.}
\usage{
get_station_information(city, directory,
  file = "station_information.rds")
}
\arguments{
\item{city}{A character string or a url to an active gbfs.json feed. See \code{get_gbfs_cities}
for a current list of available cities.}

\item{directory}{The name of an existing folder or folder to be created, where the feed will
will be saved.}

\item{file}{The name of the file to be saved. Must end in .rds.}
}
\value{
A .rds object generated from the current station_information feed.
}
\description{
\code{get_station_information} saves the station_information feed for a given city as 
a .rds object. Go to `https://github.com/NABSA/gbfs/blob/master/gbfs.md` to see 
metadata for this dataset.
}
\examples{
\donttest{get_station_information(city = 
"http://biketownpdx.socialbicycles.com/opendata/station_information.json",  directory = tempdir())}
\donttest{get_station_information(city = "Battle Creek",  directory = tempdir())}
}
