% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/functions.R
\name{ThresholdFunctions}
\alias{ThresholdFunctions}
\alias{find_threshold_crosses}
\alias{first_below}
\alias{first_above}
\title{Find point(s) when a numeric vector crosses some threshold}
\usage{
find_threshold_crosses(
  y,
  x = NULL,
  threshold,
  return = "index",
  return_rising = TRUE,
  return_falling = TRUE,
  return_endpoints = TRUE,
  subset = NULL,
  na.rm = TRUE
)

first_below(
  y,
  x = NULL,
  threshold,
  return = "index",
  return_endpoints = TRUE,
  ...
)

first_above(
  y,
  x = NULL,
  threshold,
  return = "index",
  return_endpoints = TRUE,
  ...
)
}
\arguments{
\item{y}{Numeric vector of y values in which to identify threshold
crossing event(s)}

\item{x}{Optional numeric vector of corresponding x values}

\item{threshold}{Threshold y value of interest}

\item{return}{One of \code{c("index", "x")}, determining whether the function
will return the \code{index} or \code{x} value associated with the
threshold-crossing event.

If \code{index}, it will refer to the data point immediately after
the crossing event.

If \code{x}, it will use linear interpolation and the data
points immediately before and after the threshold-crossing
to return the exact \code{x} value when the threshold crossing
occurred}

\item{return_rising}{logical for whether crossing events where \code{y}
rises above \code{threshold} should be returned}

\item{return_falling}{logical for whether crossing events where \code{y}
falls below \code{threshold} should be returned}

\item{return_endpoints}{logical for whether startpoint should be returned
when the startpoint is above \code{threshold} and
\code{return_rising = TRUE}, or when the startpoint is
below \code{threshold} and \code{return_falling = TRUE}}

\item{subset}{A vector of logical values indicating which x and y values
should be included (TRUE) or excluded (FALSE).

If \code{return = "index"}, index will be for the whole 
vector and not the subset of the vector}

\item{na.rm}{logical whether NA's should be removed before analyzing.
If \code{return = 'index'}, indices will refer to the original
\code{y} vector *including* \code{NA} values}

\item{...}{(for \code{first_above} and \code{first_below}) other arguments 
to pass to \code{find_threshold_crosses}}
}
\value{
\code{find_threshold_crosses} returns a vector corresponding to all the 
   threshold crossings.

   \code{first_above} returns only the first time the \code{y} values
   rise above the threshold, so is a shortcut for 
   \code{find_threshold_crosses(return_rising = TRUE, return_falling = FALSE)[1]}

   \code{first_below} returns only the first time the \code{y} values
   fall below the threshold, so is a shortcut for 
   \code{find_threshold_crosses(return_rising = FALSE, return_falling = TRUE)[1]}

   If \code{return = "index"}, the returned value(s) are the indices
   immediately following threshold crossing(s)
          
   If \code{return = "x"}, the returned value(s) are the x value(s) 
   corresponding to threshold crossing(s)
   
   If no threshold-crossings are detected that meet the criteria, will
   return \code{NA}
}
\description{
These functions take a vector of \code{y} values and identify points where
the \code{y} values cross some \code{threshold} y value.
}
\details{
This function is designed to be compatible for use within
 \code{dplyr::group_by} and \code{dplyr::summarize}
}
