% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/coerce.R
\name{as_array}
\alias{as_array}
\title{Convert a data cube to an in-memory R array}
\usage{
as_array(x)
}
\arguments{
\item{x}{data cube}
}
\value{
Four dimensional array with dimensions band, t, y, x
}
\description{
Convert a data cube to an in-memory R array
}
\note{
Depending on the data cube size, this function may require substantial amounts of main memory, i.e.
it makes sense for small data cubes only.
}
\examples{
\donttest{
# create image collection from example Landsat data only 
# if not already done in other examples
if (!file.exists(file.path(tempdir(), "L8.db"))) {
  L8_files <- list.files(system.file("L8NY18", package = "gdalcubes"),
                         ".TIF", recursive = TRUE, full.names = TRUE)
  create_image_collection(L8_files, "L8_L1TP", file.path(tempdir(), "L8.db")) 
}

L8.col = image_collection(file.path(tempdir(), "L8.db"))
v = cube_view(extent=list(left=388941.2, right=766552.4, 
              bottom=4345299, top=4744931, t0="2018-04", t1="2018-05"),
              srs="EPSG:32618", nx = 100, ny=100, dt="P1M")
as_array(select_bands(raster_cube(L8.col, v), c("B04", "B05")))
}
}
