% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/gdm.subsample.sitepair.R
\name{subsample.sitepair}
\alias{subsample.sitepair}
\title{Remove Sites at Random from a Site-Pair Table}
\usage{
subsample.sitepair(spTable, sampleSites)
}
\arguments{
\item{spTable}{A site-pair table, same as used to fit a \code{\link[gdm]{gdm}}.}

\item{sampleSites}{The fraction (0-1, though a value of 0 would be silly,
wouldn't it?) of \emph{sites to retain} from the full site-pair table. If
less than 1, this argument will completely remove a fraction of sites such
that they are not used in the permutation routines.}
}
\value{
A site-pair table, such as one created by \code{\link[gdm]{formatsitepair}},
ideally smaller than the one given. In the very rare case where the function
determines not to remove any sites, or should the sampleSites argument be 1,
then the function will return the full site-pair table.
}
\description{
Randomly selects a number of sites from a given site-pair table
and removes them from the site-pair table. It will remove all instances of
the sites randomly selected to be removed in both s1 and s2 positions.
}
\note{
This function removes sites, not just site-pairs (rows) from the
site-pair table. This function is called from several of the other functions
within the gdm package, including the \code{\link[gdm]{plotUncertainty}} and
\code{\link[gdm]{gdm.varImp}} functions, for the purposes of subsampling the sites
in the site-pair table.
}
\examples{
##set up site-pair table using the southwest data set
sppData <- southwest[, c(1,2,13,14)]
envTab <- southwest[, c(2:ncol(southwest))]
sitePairTab <- formatsitepair(sppData, 2, XColumn="Long", YColumn="Lat", sppColumn="species",
                              siteColumn="site", predData=envTab)

subsample.sitepair(sitePairTab, sampleSites=0.7)

}
\seealso{
\code{\link[gdm]{formatsitepair}}
}
\keyword{gdm}
