% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/set_config.R
\name{set_config}
\alias{set_config}
\title{Initialize the Configuration File}
\usage{
set_config(
  path,
  regions,
  source,
  start = "2020-01-01",
  resol,
  scale = NULL,
  limit = 10000,
  verbose = TRUE
)
}
\arguments{
\item{path}{[mandatory] (character) The path to the root directory of the
generated database. This must be a writable, non-temporary directory.
Avoid using the home directory (~), the current working directory, or the
package directory.}

\item{regions}{[mandatory] (character) ISO 3166-1 alpha-2 country codes or
ISO 3166-2 subdivision codes.}

\item{source}{[mandatory] (list) Description of Google Earth Engine (GEE)
  datasets of interest (the complete data catalog of GEE is accessible at:
  \url{https://developers.google.com/earth-engine/datasets/catalog}). It is
  a nested list with three levels:
\describe{
  \item{names}{(list) Datasets of interest (e.g.,
  \code{"MODIS/061/MOD13A1"}).
    \describe{
      \item{bands}{(list) Bands of interest (e.g., \code{"NDVI"}).
        \describe{
          \item{zonal_stats}{(character) Statistics of interest
          (options: \code{"mean"}, \code{"median"}, \code{"min"},
          \code{"max"}, \code{"sd"}).}
        }
      }
    }
  }
}}

\item{start}{[optional] (date) First date of the data collection
(default: \code{"2020-01-01"}).}

\item{resol}{[mandatory] (integer) Resolution of the H3 bin.}

\item{scale}{[optional] (integer) Specifies the nominal resolution
(in meters) for image processing. If left as \code{NULL} (the default), a
resolution of 1000 is used.}

\item{limit}{[optional] (integer) In \code{"local"} mode, `limit / dates`
sets batch size; in \code{"drive"} mode, `limit` is the max features per
export (default: \code{10000}).}

\item{verbose}{[optional] (logical) Display messages (default: \code{TRUE}).}
}
\value{
No return value, called for side effects.
}
\description{
Creates a configuration file in the specified directory of the generated
database (\code{config/config.json}). If the specified directory does not
exist but its parent directory does, it will be created.
}
\examples{
\dontrun{
  set_config(path = tempdir(),
             regions = c("SO", "YM"),
             source = list(
              "MODIS/061/MOD13A1" = list(
                "NDVI" = c("mean", "sd")
             )
            ),
            resol = 3)
}
}
