/*
 * Decompiled with CFR 0.152.
 */
package org.drugis.common.beans;

import com.jgoodies.binding.list.ObservableList;
import javax.swing.event.ListDataEvent;
import javax.swing.event.ListDataListener;
import org.apache.commons.collections15.Predicate;
import org.drugis.common.beans.AbstractObservableList;

public class GuardedObservableList<E>
extends AbstractObservableList<E> {
    ObservableList<E> d_nested;
    private final Predicate<? super E> d_predicate;

    public GuardedObservableList(ObservableList<E> nested, Predicate<? super E> predicate) {
        if (!nested.isEmpty()) {
            throw new IllegalArgumentException("Initial nested list must be empty.");
        }
        this.d_nested = nested;
        this.d_predicate = predicate;
        this.d_nested.addListDataListener(new ListDataListener(){

            @Override
            public void intervalRemoved(ListDataEvent e) {
                GuardedObservableList.this.fireIntervalRemoved(e.getIndex0(), e.getIndex1());
            }

            @Override
            public void intervalAdded(ListDataEvent e) {
                GuardedObservableList.this.fireIntervalAdded(e.getIndex0(), e.getIndex1());
            }

            @Override
            public void contentsChanged(ListDataEvent e) {
                GuardedObservableList.this.fireContentsChanged(e.getIndex0(), e.getIndex1());
            }
        });
    }

    @Override
    public E get(int index) {
        return this.d_nested.get(index);
    }

    @Override
    public int size() {
        return this.d_nested.size();
    }

    @Override
    public void add(int index, E element) {
        this.check(element);
        this.d_nested.add(index, element);
    }

    @Override
    public E set(int index, E element) {
        this.check(element);
        return this.d_nested.set(index, element);
    }

    @Override
    public E remove(int index) {
        return this.d_nested.remove(index);
    }

    private void check(E element) {
        if (!this.d_predicate.evaluate(element)) {
            throw new IllegalArgumentException("The element " + element + " does not fulfill the guard predicate: " + this.d_predicate + ".");
        }
    }
}

