/*
 * Decompiled with CFR 0.152.
 */
package org.drugis.mtc.parameterization;

import edu.uci.ics.jung.graph.UndirectedGraph;
import edu.uci.ics.jung.graph.UndirectedSparseGraph;
import edu.uci.ics.jung.graph.util.Pair;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import org.drugis.mtc.graph.GraphUtil;
import org.drugis.mtc.model.Treatment;
import org.drugis.mtc.parameterization.CompareUtil;
import org.drugis.mtc.parameterization.Part;
import org.drugis.mtc.parameterization.TreatmentComparator;

public class Partition {
    private final Set<Part> d_parts;
    private boolean d_reduced;

    public Partition(Collection<Part> parts) {
        this.d_parts = new HashSet<Part>(parts);
        if (!Partition.validPartition(this.d_parts)) {
            throw new IllegalArgumentException("Given parts do not form a valid partition");
        }
        this.d_reduced = false;
    }

    public boolean equals(Object obj) {
        if (obj instanceof Partition) {
            Partition other = (Partition)obj;
            return ((Object)other.d_parts).equals(this.d_parts);
        }
        return false;
    }

    public int hashCode() {
        return ((Object)this.d_parts).hashCode();
    }

    public String toString() {
        return "Partition{" + this.d_parts.toString() + "}";
    }

    public Set<Part> getParts() {
        return Collections.unmodifiableSet(this.d_parts);
    }

    public Partition reduce() {
        Treatment tNext;
        if (this.d_reduced) {
            return this;
        }
        UndirectedGraph<Treatment, Part> graph = Partition.buildGraph(this.d_parts);
        if (graph == null) {
            return this;
        }
        Treatment v0 = CompareUtil.findLeast(graph.getVertices(), TreatmentComparator.INSTANCE);
        Part p = (Part)graph.getIncidentEdges(v0).iterator().next();
        Pair<Treatment> treatments = new Pair<Treatment>(v0, Partition.otherTreatment(p, v0));
        HashSet<Part> visited = new HashSet<Part>();
        Treatment tRight = this.walk(graph, p, treatments.getFirst(), visited);
        if (tRight.equals(treatments.getFirst())) {
            return new Partition(Collections.singleton(new Part(tRight, tRight, p.getStudies())));
        }
        Treatment tLeft = this.walk(graph, p, treatments.getSecond(), visited);
        HashSet<Part> reduced = new HashSet<Part>();
        reduced.add(new Part(tRight, tLeft, p.getStudies()));
        do {
            p = Partition.nextPart(graph, visited, tRight);
            tNext = this.walk(graph, p, tRight, visited);
            reduced.add(new Part(tRight, tNext, p.getStudies()));
        } while (!(tRight = tNext).equals(tLeft));
        Partition partition = new Partition(reduced);
        partition.d_reduced = true;
        return partition;
    }

    public List<Treatment> asCycle() {
        UndirectedGraph<Treatment, Part> graph = Partition.buildGraph(this.d_parts);
        ArrayList<Treatment> cycle = new ArrayList<Treatment>(this.d_parts.size() + 1);
        Part p0 = (Part)graph.getEdges().iterator().next();
        Pair<Treatment> treatments = new Pair<Treatment>(p0.getTreatments());
        cycle.addAll(treatments);
        for (int i = 1; i < this.d_parts.size(); ++i) {
            Part pNext = Partition.nextPart(graph, (Treatment)cycle.get(i - 1), (Treatment)cycle.get(i));
            cycle.add(Partition.otherTreatment(pNext, (Treatment)cycle.get(i)));
        }
        return cycle;
    }

    private Treatment walk(UndirectedGraph<Treatment, Part> graph, Part p0, Treatment t0, Set<Part> visited) {
        visited.add(p0);
        Treatment tPrev = t0;
        Treatment tCurr = Partition.otherTreatment(p0, t0);
        Part pNext = Partition.nextPart(graph, tPrev, tCurr);
        while (((Object)p0.getStudies()).equals(pNext.getStudies()) && !t0.equals(tCurr)) {
            tPrev = tCurr;
            tCurr = Partition.otherTreatment(pNext, tCurr);
            visited.add(pNext);
            pNext = Partition.nextPart(graph, tPrev, tCurr);
        }
        return tCurr;
    }

    private static boolean validPartition(Set<Part> parts) {
        if (parts.isEmpty()) {
            return false;
        }
        if (parts.size() == 1) {
            return parts.iterator().next().getTreatments().size() == 1;
        }
        if (parts.size() == 2) {
            Iterator<Part> iterator = parts.iterator();
            Part p1 = iterator.next();
            Part p2 = iterator.next();
            return ((Object)p1.getTreatments()).equals(p2.getTreatments()) && p1.getTreatments().size() == 2;
        }
        UndirectedGraph<Treatment, Part> graph = Partition.buildGraph(parts);
        return graph == null ? false : GraphUtil.isSimpleCycle(graph);
    }

    private static UndirectedGraph<Treatment, Part> buildGraph(Set<Part> parts) {
        UndirectedSparseGraph<Treatment, Part> graph = new UndirectedSparseGraph<Treatment, Part>();
        for (Part p : parts) {
            if (p.getTreatments().size() != 2) {
                return null;
            }
            Iterator<Treatment> iterator = p.getTreatments().iterator();
            Treatment t1 = iterator.next();
            Treatment t2 = iterator.next();
            graph.addEdge(p, t1, t2);
        }
        return graph;
    }

    private static Treatment otherTreatment(Part p, Treatment t) {
        Pair<Treatment> treatments = new Pair<Treatment>(p.getTreatments());
        if (treatments.getFirst().equals(t)) {
            return treatments.getSecond();
        }
        return treatments.getFirst();
    }

    private static Part nextPart(UndirectedGraph<Treatment, Part> g, Treatment tPrev, Treatment tCurr) {
        Pair parts = new Pair(g.getIncidentEdges(tCurr));
        if (((Part)parts.getFirst()).getTreatments().contains(tPrev)) {
            return (Part)parts.getSecond();
        }
        return (Part)parts.getFirst();
    }

    private static Part nextPart(UndirectedGraph<Treatment, Part> g, Set<Part> visited, Treatment tCurr) {
        Pair parts = new Pair(g.getIncidentEdges(tCurr));
        if (visited.contains(parts.getFirst())) {
            return (Part)parts.getSecond();
        }
        return (Part)parts.getFirst();
    }
}

