/*
 * Decompiled with CFR 0.152.
 */
package org.drugis.mtc.summary;

import java.util.AbstractList;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.math3.stat.descriptive.StorelessUnivariateStatistic;
import org.drugis.mtc.MCMCResults;
import org.drugis.mtc.Parameter;

public class SummaryUtil {
    public static double evaluate(StorelessUnivariateStatistic stat, List<Double> vals) {
        stat.clear();
        for (Double d : vals) {
            stat.increment(d);
        }
        return stat.getResult();
    }

    public static List<Double> getAllChainsLastHalfSamples(MCMCResults results, Parameter parameter) {
        ArrayList<List<Double>> lists = new ArrayList<List<Double>>();
        for (int i = 0; i < results.getNumberOfChains(); ++i) {
            lists.add(SummaryUtil.getOneChainLastHalfSamples(results, parameter, i));
        }
        return new ConcatenationView(lists);
    }

    public static List<Double> getOneChainLastHalfSamples(MCMCResults results, Parameter parameter, int c) {
        int p = results.findParameter(parameter);
        return new LastHalfView(new ResultsView(results, p, c));
    }

    public static class ConcatenationView
    extends AbstractList<Double> {
        private final List<List<Double>> d_lists;

        public ConcatenationView(List<List<Double>> lists) {
            this.d_lists = lists;
        }

        @Override
        public int size() {
            return this.d_lists.size() * this.d_lists.get(0).size();
        }

        @Override
        public Double get(int idx) {
            int size = this.d_lists.get(0).size();
            return this.d_lists.get(idx / size).get(idx % size);
        }
    }

    public static class LastHalfView
    extends AbstractList<Double> {
        private final List<Double> d_list;

        public LastHalfView(List<Double> list) {
            this.d_list = list;
        }

        @Override
        public int size() {
            return this.d_list.size() / 2;
        }

        @Override
        public Double get(int idx) {
            return this.d_list.get(this.size() + idx);
        }
    }

    public static class ResultsView
    extends AbstractList<Double> {
        private final MCMCResults d_results;
        private final int d_param;
        private final int d_chain;

        public ResultsView(MCMCResults r, int p, int c) {
            this.d_results = r;
            this.d_param = p;
            this.d_chain = c;
        }

        @Override
        public int size() {
            return this.d_results.getNumberOfSamples();
        }

        @Override
        public Double get(int idx) {
            return this.d_results.getSample(this.d_param, this.d_chain, idx);
        }
    }
}

