/*
 * Decompiled with CFR 0.152.
 */
package org.drugis.common.beans;

import com.jgoodies.binding.list.ObservableList;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javax.swing.event.ListDataEvent;
import javax.swing.event.ListDataListener;
import org.apache.commons.collections15.Predicate;
import org.drugis.common.beans.AbstractObservableList;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FilteredObservableList<E>
extends AbstractObservableList<E> {
    private final ObservableList<E> d_inner;
    private Predicate<E> d_filter;
    private final ArrayList<Integer> d_indices = new ArrayList();

    public FilteredObservableList(ObservableList<E> inner, Predicate<E> filter) {
        this.d_inner = inner;
        this.d_filter = filter;
        this.initializeIndices();
        this.d_inner.addListDataListener(new ListDataListener(){

            public void intervalRemoved(ListDataEvent e) {
                FilteredObservableList.this.intervalRemoved(e.getIndex0(), e.getIndex1());
            }

            public void intervalAdded(ListDataEvent e) {
                FilteredObservableList.this.intervalAdded(e.getIndex0(), e.getIndex1());
            }

            public void contentsChanged(ListDataEvent e) {
                FilteredObservableList.this.contentsChanged(e.getIndex0(), e.getIndex1());
            }
        });
    }

    private void initializeIndices() {
        for (int i = 0; i < this.d_inner.size(); ++i) {
            if (!this.d_filter.evaluate(this.d_inner.get(i))) continue;
            this.d_indices.add(i);
        }
    }

    public void setFilter(Predicate<E> filter) {
        this.d_filter = filter;
        int oldSize = this.size();
        if (!this.isEmpty()) {
            this.d_indices.clear();
            this.fireIntervalRemoved(0, oldSize - 1);
        }
        this.initializeIndices();
        if (!this.isEmpty()) {
            this.fireIntervalAdded(0, this.size() - 1);
        }
    }

    protected <F> int findFirstIndex(List<F> list, Predicate<F> filter) {
        for (int i = 0; i < list.size(); ++i) {
            if (!filter.evaluate(list.get(i))) continue;
            return i;
        }
        return -1;
    }

    @Override
    public E get(int index) {
        return this.d_inner.get(this.d_indices.get(index));
    }

    @Override
    public void add(int index, E element) {
        if (!this.d_filter.evaluate(element)) {
            throw new IllegalArgumentException("Cannot add " + element + ", it does not pass the filter of " + this);
        }
        if (index < this.d_indices.size()) {
            this.d_inner.add(this.d_indices.get(index), element);
        } else {
            this.d_inner.add(this.d_inner.size(), element);
        }
    }

    @Override
    public E set(int index, E element) {
        if (!this.d_filter.evaluate(element)) {
            throw new IllegalArgumentException("Cannot add " + element + ", it does not pass the filter.");
        }
        return this.d_inner.set(this.d_indices.get(index), element);
    }

    @Override
    public E remove(int index) {
        return this.d_inner.remove(this.d_indices.get(index));
    }

    @Override
    public int size() {
        return this.d_indices.size();
    }

    private void intervalRemoved(int lower, int upper) {
        int first = this.firstAtLeast(lower);
        if (first >= this.d_indices.size()) {
            return;
        }
        int last = this.firstOver(upper);
        this.d_indices.removeAll(new ArrayList<Integer>(this.d_indices.subList(first, last)));
        int delta = upper - lower + 1;
        this.updateIndices(first, -delta);
        if (last > first) {
            this.fireIntervalRemoved(first, last - 1);
        }
    }

    private void intervalAdded(int lower, int upper) {
        int delta = upper - lower + 1;
        int first = this.firstAtLeast(lower);
        this.updateIndices(first, delta);
        int oldSize = this.d_indices.size();
        for (int i = upper; i >= lower; --i) {
            if (!this.d_filter.evaluate(this.d_inner.get(i))) continue;
            this.d_indices.add(first, i);
        }
        int inserted = this.d_indices.size() - oldSize;
        if (inserted > 0) {
            this.fireIntervalAdded(first, first + inserted - 1);
        }
    }

    private void contentsChanged(int lower, int upper) {
        for (int i = lower; i <= upper; ++i) {
            this.elementChanged(i);
        }
    }

    private void elementChanged(int elm) {
        int idx = Collections.binarySearch(this.d_indices, elm);
        if (idx >= 0) {
            if (this.d_filter.evaluate(this.d_inner.get(elm))) {
                this.fireContentsChanged(idx, idx);
            } else {
                this.d_indices.remove(idx);
                this.fireIntervalRemoved(idx, idx);
            }
        } else if (this.d_filter.evaluate(this.d_inner.get(elm))) {
            this.d_indices.add(-(idx + 1), elm);
            this.fireIntervalAdded(-(idx + 1), -(idx + 1));
        }
    }

    private void updateIndices(int first, int delta) {
        for (int idx = first; idx < this.d_indices.size(); ++idx) {
            this.d_indices.set(idx, this.d_indices.get(idx) + delta);
        }
    }

    private int firstOver(final int x) {
        int last = this.findFirstIndex(this.d_indices, new Predicate<Integer>(){

            @Override
            public boolean evaluate(Integer index) {
                return index > x;
            }
        });
        return last < 0 ? this.d_indices.size() : last;
    }

    private int firstAtLeast(final int x) {
        int first = this.findFirstIndex(this.d_indices, new Predicate<Integer>(){

            @Override
            public boolean evaluate(Integer index) {
                return index >= x;
            }
        });
        return first < 0 ? this.d_indices.size() : first;
    }
}

