/*
 * Decompiled with CFR 0.152.
 */
package org.drugis.common.beans;

import com.jgoodies.binding.beans.Observable;
import com.jgoodies.binding.list.ObservableList;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.Arrays;
import java.util.List;
import javax.swing.event.ListDataEvent;
import javax.swing.event.ListDataListener;
import org.drugis.common.beans.AbstractObservableList;
import org.drugis.common.beans.ListPropertyChangeProxy;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ContentAwareListModel<T extends Observable>
extends AbstractObservableList<T> {
    private ObservableList<T> d_nested;
    private ListPropertyChangeProxy<T> d_proxy;
    private List<String> d_properties;

    public ContentAwareListModel(ObservableList<T> list) {
        this(list, null);
    }

    public ContentAwareListModel(ObservableList<T> list, String[] properties) {
        this.d_nested = list;
        if (properties != null) {
            this.d_properties = Arrays.asList(properties);
        }
        this.d_nested.addListDataListener(new ListDataListener(){

            public void intervalRemoved(ListDataEvent e) {
                ContentAwareListModel.this.fireIntervalRemoved(e.getIndex0(), e.getIndex1());
            }

            public void intervalAdded(ListDataEvent e) {
                ContentAwareListModel.this.fireIntervalAdded(e.getIndex0(), e.getIndex1());
            }

            public void contentsChanged(ListDataEvent e) {
                ContentAwareListModel.this.fireContentsChanged(e.getIndex0(), e.getIndex1());
            }
        });
        this.d_proxy = new ListPropertyChangeProxy<T>(this.d_nested, new PropertyChangeListener(){

            public void propertyChange(PropertyChangeEvent evt) {
                if (ContentAwareListModel.this.d_properties == null || ContentAwareListModel.this.d_properties.contains(evt.getPropertyName())) {
                    int idx = ContentAwareListModel.this.d_nested.indexOf(evt.getSource());
                    ContentAwareListModel.this.fireContentsChanged(idx, idx);
                }
            }
        });
    }

    @Override
    public T get(int index) {
        return (T)((Observable)this.d_nested.get(index));
    }

    @Override
    public int size() {
        return this.d_nested.size();
    }

    public ObservableList<T> getList() {
        return this.d_nested;
    }

    @Override
    public void add(int index, T element) {
        this.d_nested.add(index, element);
    }

    @Override
    public T set(int index, T element) {
        return (T)((Observable)this.d_nested.set(index, element));
    }

    @Override
    public T remove(int index) {
        return (T)((Observable)this.d_nested.remove(index));
    }
}

