/*
 * Decompiled with CFR 0.152.
 */
package org.drugis.mtc.graph;

import edu.uci.ics.jung.algorithms.shortestpath.DijkstraShortestPath;
import edu.uci.ics.jung.algorithms.shortestpath.Distance;
import edu.uci.ics.jung.algorithms.shortestpath.ShortestPath;
import edu.uci.ics.jung.graph.DelegateTree;
import edu.uci.ics.jung.graph.Tree;
import edu.uci.ics.jung.graph.UndirectedGraph;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.LinkedList;
import java.util.Map;
import org.apache.commons.collections15.Transformer;
import org.drugis.mtc.graph.AbsoluteOneCenter;
import org.drugis.mtc.graph.PointOnEdge;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MinimumDiameterSpanningTree<V, E> {
    private final UndirectedGraph<V, E> d_graph;
    private final Transformer<E, Number> d_edgeLength;
    private final Distance<V> d_distance;
    private final ShortestPath<V, E> d_shortestPath;
    private final Comparator<V> d_vertexComparator;

    public MinimumDiameterSpanningTree(UndirectedGraph<V, E> graph) {
        this(graph, new AbsoluteOneCenter.UnitLength(), new DijkstraShortestPath<V, E>(graph));
    }

    public MinimumDiameterSpanningTree(UndirectedGraph<V, E> graph, Comparator<V> vertexComparator) {
        this(graph, new AbsoluteOneCenter.UnitLength(), new DijkstraShortestPath<V, E>(graph), vertexComparator);
    }

    public MinimumDiameterSpanningTree(UndirectedGraph<V, E> graph, Transformer<E, Number> edgeLength) {
        this(graph, edgeLength, new DijkstraShortestPath<V, E>(graph, edgeLength));
    }

    public MinimumDiameterSpanningTree(UndirectedGraph<V, E> graph, Transformer<E, Number> edgeLength, DijkstraShortestPath<V, E> shortestPath) {
        this(graph, edgeLength, shortestPath, shortestPath);
    }

    public MinimumDiameterSpanningTree(UndirectedGraph<V, E> graph, Transformer<E, Number> edgeLength, DijkstraShortestPath<V, E> shortestPath, Comparator<V> vertexComparator) {
        this(graph, edgeLength, shortestPath, shortestPath, vertexComparator);
    }

    public MinimumDiameterSpanningTree(UndirectedGraph<V, E> graph, Transformer<E, Number> edgeLength, Distance<V> distance, ShortestPath<V, E> shortestPath) {
        this(graph, edgeLength, distance, shortestPath, null);
    }

    public MinimumDiameterSpanningTree(UndirectedGraph<V, E> graph, Transformer<E, Number> edgeLength, Distance<V> distance, ShortestPath<V, E> shortestPath, Comparator<V> vertexComparator) {
        this.d_graph = graph;
        this.d_edgeLength = edgeLength;
        this.d_distance = distance;
        this.d_shortestPath = shortestPath;
        this.d_vertexComparator = vertexComparator;
    }

    public Tree<V, E> getMinimumDiameterSpanningTree() {
        int vc;
        PointOnEdge<V, E> center = new AbsoluteOneCenter<V, E>(this.d_graph, this.d_edgeLength, this.d_distance, this.d_vertexComparator).getCenter();
        DelegateTree<V, E> tree = new DelegateTree<V, E>();
        double dc = center.getDistance() - 0.5 * this.l(center.getEdge());
        int n = vc = this.d_vertexComparator == null ? 0 : this.d_vertexComparator.compare(center.getVertex0(), center.getVertex1());
        if (dc < 0.0 || dc == 0.0 && vc <= 0) {
            tree.setRoot(center.getVertex0());
            tree.addChild(center.getEdge(), center.getVertex0(), center.getVertex1());
        } else {
            tree.setRoot(center.getVertex1());
            tree.addChild(center.getEdge(), center.getVertex1(), center.getVertex0());
        }
        for (Object v : this.d_graph.getVertices()) {
            if (v.equals(center.getVertex0()) || v.equals(center.getVertex1())) continue;
            double d0 = this.d_distance.getDistance(center.getVertex0(), v).doubleValue();
            double d1 = this.d_distance.getDistance(center.getVertex1(), v).doubleValue();
            double d = d0 + center.getDistance() - (d1 + this.l(center.getEdge()) - center.getDistance());
            if (d < 0.0 || d == 0.0 && vc <= 0) {
                this.addPath(tree, center.getVertex0(), v);
                continue;
            }
            this.addPath(tree, center.getVertex1(), v);
        }
        return tree;
    }

    private void addPath(DelegateTree<V, E> tree, V u, V v) {
        Map<V, E> incomingEdgeMap = this.d_shortestPath.getIncomingEdgeMap(u);
        LinkedList<V> path = new LinkedList<V>();
        while (!v.equals(u)) {
            path.addFirst(v);
            E e = incomingEdgeMap.get(v);
            ArrayList incidentVertices = new ArrayList(this.d_graph.getIncidentVertices(e));
            v = incidentVertices.get(0).equals(v) ? incidentVertices.get(1) : incidentVertices.get(0);
        }
        path.addFirst(u);
        for (int i = 0; i < path.size() - 1; ++i) {
            Object e = this.d_graph.findEdge(path.get(i), path.get(i + 1));
            if (tree.containsEdge(e)) continue;
            tree.addChild(e, path.get(i), path.get(i + 1));
        }
    }

    private double l(E e) {
        return this.d_edgeLength.transform(e).doubleValue();
    }
}

