% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/getLambdaFun.R
\name{getLambdaFun}
\alias{getLambdaFun}
\title{Estimate Death Rate}
\usage{
getLambdaFun(
  tTarget,
  Q,
  R,
  guess,
  ftol,
  ptol,
  gtol,
  epsfcn,
  factor,
  maxfev,
  maxiter,
  nprint,
  trace
)
}
\arguments{
\item{tTarget}{target time vector}

\item{Q}{target time-histories of the quarantined cases}

\item{R}{target time-histories of the recovered cases}

\item{guess}{Initiail guess parameters for kappa}

\item{ftol}{nls.lm.control object. non-negative numeric. Default is \code{1e-6}}

\item{ptol}{nls.lm.control object. non-negative numeric. Default is \code{1e-6}}

\item{gtol}{nls.lm.control object. non-negative numeric. Default is \code{1e-6}}

\item{epsfcn}{nls.lm.control object. Default is \code{0.001}}

\item{factor}{nls.lm.control object. Default is \code{100}}

\item{maxfev}{nls.lm.control object. Default is \code{1000}}

\item{maxiter}{nls.lm.control object. Default is \code{100}}

\item{nprint}{nls.lm.control object. Default is \code{1}}

\item{trace}{set \code{TRUE} to trace iteration results}
}
\value{
vector of estimation and optimization function for the recovery rate
}
\description{
This function provides a first estimate of the  recovery rate, to faciliate
convergence of the main algorithm.
}
\references{
Peng, L., Yang, W., Zhang, D., Zhuge, C., Hong, L. 2020. “Epidemic analysis of COVID-19 in China by dynamical modeling”, arXiv preprint arXiv:2002.06563.

\url{https://www.mathworks.com/matlabcentral/fileexchange/74545-generalized-seir-epidemic-model-fitting-and-computation}
}
\seealso{
\code{\link{SEIQRDP}} \code{\link{fit_SEIQRDP}}
}
\author{
Selcuk Korkmaz, \email{selcukorkmaz@gmail.com}
}
