% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/phenos.R
\name{hapVsPhenos}
\alias{hapVsPhenos}
\title{hapVsPhenos}
\usage{
hapVsPhenos(hap, pheno,
         outPutSingleFile = TRUE,
         hapPrefix = "H",
         title = "Seita.0G000000",
         width = 12,
         height = 8,
         res = res,
         compression = "lzw",
         filename.prefix = filename.prefix,
         filename.surfix = "pdf",
         filename.sep = "_",
         outlier.rm = TRUE,
         ...)
}
\arguments{
\item{hap}{object of hapResult class, generate with\code{vcf2hap()} or
\code{seqs2hap()}}

\item{pheno}{object of data.frame class, imported by \code{import_pheno()}}

\item{outPutSingleFile}{\code{TRUE} or \code{FALSE} indicate whether put all figs
into to each pages of single file or generate multi-files.
Only worked while file type is pdf}

\item{hapPrefix}{prefix of hapotypes, default as "H"}

\item{title}{a charater which will used for figure title}

\item{width}{manual option for determining the output file width in inches.
(default: 12)}

\item{height}{manual option for determining the output file height in inches.
(default: 8)}

\item{res}{The nominal resolution in ppi which will be recorded in the
bitmap file, if a positive integer. Also used for units other than the
default, and to convert points to pixels}

\item{compression}{the type of compression to be used.}

\item{filename.prefix, filename.surfix, filename.sep}{if multi files generated, file names will be formed by
prefix \code{filename.prefix}, a seperate charcter \code{filename.sep},
pheno name, a dot and surfix \code{filename.surfix},
and file type was decide by \code{filename.surfix};
if single file was generated, file name will be formed by
prefix \code{filename.prefix}, a dot and surfix \code{filename.surfix}}

\item{outlier.rm}{whether remove ouliers, default as TRUE}

\item{...}{options will pass to \code{ggpubr()}}
}
\value{
No return value
}
\description{
hapVsPhenos
}
\examples{
data("geneHapR_test")

oriDir <- getwd()
setwd(tempdir())
# analysis all pheno in the data.frame of pheno
hapVsPhenos(hapResult,
            pheno,
            outPutSingleFile = TRUE,
            hapPrefix = "H",
            title = "Seita.0G000000",
            filename.prefix = "test",
            width = 12,
            height = 8,
            res = 300)
setwd(oriDir)
}
