% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/vis_phenos.R
\name{hapVsPhenos}
\alias{hapVsPhenos}
\title{hapVsPhenos}
\usage{
hapVsPhenos(
  hap,
  pheno,
  outPutSingleFile = TRUE,
  hapPrefix = "H",
  title = "Seita.0G000000",
  width = 12,
  height = 8,
  res = 300,
  compression = "lzw",
  filename.prefix = filename.prefix,
  filename.surfix = "pdf",
  filename.sep = "_",
  outlier.rm = TRUE,
  mergeFigs = TRUE,
  ...
)
}
\arguments{
\item{hap}{object of hapResult class, generate with\code{vcf2hap()} or
\code{seqs2hap()}}

\item{pheno}{object of data.frame class, imported by \code{import_pheno()}}

\item{outPutSingleFile}{\code{TRUE} or \code{FALSE} indicate whether put all figs
into to each pages of single file or generate multi-files.
Only worked while file type is pdf}

\item{hapPrefix}{prefix of hapotypes, default as "H"}

\item{title}{a charater which will used for figure title}

\item{width}{manual option for determining the output file width in inches.
(default: 12)}

\item{height}{manual option for determining the output file height in inches.
(default: 8)}

\item{res}{The nominal resolution in ppi which will be recorded in the
bitmap file, if a positive integer. Also used for units other than the
default, and to convert points to pixels}

\item{compression}{the type of compression to be used.}

\item{filename.prefix, filename.surfix, filename.sep}{if multi files generated, file names will be formed by
prefix \code{filename.prefix}, a seperate charcter \code{filename.sep},
pheno name, a dot and surfix \code{filename.surfix},
and file type was decide by \code{filename.surfix};
if single file was generated, file name will be formed by
prefix \code{filename.prefix}, a dot and surfix \code{filename.surfix}}

\item{outlier.rm}{whether remove ouliers, default as TRUE}

\item{mergeFigs}{bool type, indicate whether merge the heat map and box
plot or not. Default as \code{FALSE}}

\item{...}{
  Arguments passed on to \code{\link[=hapVsPheno]{hapVsPheno}}
  \describe{
    \item{\code{phenoName}}{pheno name for plot, should be one column name of pheno}
    \item{\code{minAcc}}{If observations number of a Hap less than this number will
not be compared with others or be ploted. Should not less than 3 due to the
t-test will meaninglessly. default as 5}
    \item{\code{angle}}{the angle of x labels}
    \item{\code{hjust,vjust}}{hjust and vjust of x labels}
    \item{\code{comparisons}}{a list contains comparison pairs
eg. \code{list(c("H001", "H002"), c("H001", "H004"))},
or a character vector contains haplotype names for comparison,
or "none" indicates do not add comparisons.}
    \item{\code{method}}{a character string indicating which method to be used for
comparing means.}
    \item{\code{method.args}}{a list of additional arguments used for the test method.
For example one might use \code{method.args = list(alternative = "greater")}
for wilcoxon test.}
    \item{\code{symnum.args}}{a list of arguments to pass to the function
 \code{\link[stats]{symnum}} for symbolic number coding of p-values. For
 example, \code{symnum.args <- list(cutpoints = c(0, 0.0001, 0.001,
 0.01, 0.05, 1), symbols = c("****", "***", "**", "*",  "ns"))}.

 In other words, we use the following convention for symbols indicating
 statistical significance: \itemize{ \item \code{ns}: p > 0.05 \item
 \code{*}: p <= 0.05 \item \code{**}: p <= 0.01 \item \code{***}: p <= 0.001 \item \code{****}:  p <= 0.0001 }}
  }}
}
\value{
No return value
}
\description{
hapVsPhenos
}
\examples{
data("geneHapR_test")

oriDir <- getwd()
setwd(tempdir())
# analysis all pheno in the data.frame of pheno
hapVsPhenos(hapResult,
            pheno,
            outPutSingleFile = TRUE,
            hapPrefix = "H",
            title = "Seita.0G000000",
            filename.prefix = "test",
            width = 12,
            height = 8,
            res = 300)
setwd(oriDir)
}
