% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Genepop.R
\name{Differentiation}
\alias{Differentiation}
\alias{test_diff}
\title{Tests of genic and genotypic differentiation}
\usage{
test_diff(inputFile, genic = TRUE, pairs = FALSE, outputFile = "",
  settingsFile = "", dememorization = 10000, batches = 100,
  iterations = 5000, verbose = interactive())
}
\arguments{
\item{inputFile}{The path of the input file, in Genepop format}

\item{genic}{logical: whether to perform genic or genotypic tests}

\item{pairs}{logical: whether to test differentiation between all pairs of ppulation, or to perform a single global test}

\item{outputFile}{character: The path of the output file}

\item{settingsFile}{character: The path of the settings file}

\item{dememorization}{integer: length of dememorization step of Markov chain algorithm}

\item{batches}{integer: Number of batches}

\item{iterations}{integer: Iterations per batch}

\item{verbose}{logical: whether to print some information}
}
\value{
The path of the output file is returned invisibly.
}
\description{
Exact conditional contingency-table tests for genic or genotypic differentiation. A single test for all populations, or distinct tests for all pairs of populations, may be computed. See \href{../doc/all-menu-options.html#option-3-population-differentiation}{this section} of the Genepop executable documentation for more information on the statistical methods.
}
\examples{
infile <- system.file('extdata', 'sample.txt',package='genepop')
locinfile <- 'sample.txt' ## file in user's directory not in R's extdata directory
check <- file.copy(infile,locinfile,overwrite=TRUE)
test_diff(locinfile,outputFile='sample.txt.GE')
if ( ! interactive()) clean_workdir(otherfiles='sample.txt')
}
