% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/sex_to_char.R
\name{sex_to_char}
\alias{sex_to_char}
\title{Convert integer sex codes to character codes}
\usage{
sex_to_char(sex)
}
\arguments{
\item{sex}{Integer vector of sex codes}
}
\value{
The converged character vector of sex codes
}
\description{
This function accepts the integer sex codes accepted by plink and turns them into the character codes accepted by eigenstrat.
Only upper-case characters are returned.
The correspondence is:
\describe{
\item{0:}{ U (unknown) }
\item{1:}{ M (male) }
\item{2:}{ F (female) }
}
Any other cases will also be mapped to U (unknown) but with a warning (0 does not generate warnings).
}
\examples{
# verify the mapping above
sex_int <- 0:2
sex_char <- c('U', 'M', 'F') # expected values
stopifnot(
  all(
    sex_to_char( sex_int ) == sex_char
  )
)

}
\seealso{
\code{\link{sex_to_int}}

Eigenstrat IND format reference:
\url{https://github.com/DReichLab/EIG/tree/master/CONVERTF}

Plink FAM format reference:
\url{https://www.cog-genomics.org/plink/1.9/formats#fam}
}
