% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/cells.R
\name{cells_suggest}
\alias{cells_suggest}
\title{Suggest Cell Matches Based on Query Values}
\usage{
cells_suggest(queryValues, responseType = "json", debug = 0, options = list())
}
\arguments{
\item{queryValues}{A character vector of cell names or identifiers to find matches for.}

\item{responseType}{A character string indicating the type of response to expect ('json' or 'csv').}

\item{debug}{An integer value indicating whether to enable debug mode (1) or not (0).}

\item{options}{A list that specifies the API endpoint, api_key, timeout duration, and user agent string,
with default values preset for the 'Genular' API cell suggestion endpoint.}
}
\value{
A list containing suggested cell matches, each with associated details like keys,
values, search scores, and expression marker scores.
}
\description{
This function communicates with the 'Genular' API to suggest cell matches
based on an array of query values. It sends a POST request with the query
values and retrieves suggested cell matches, including details and scores.
}
\examples{
queryValues <- c("endothelial cell", "T cell")
cell_suggest_results <- cells_suggest(queryValues)
print(cell_suggest_results)
}
