% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/orthproj.R
\name{orthproj}
\alias{orthproj}
\title{Performs an orthogonal projection to a curve.}
\usage{
orthproj(pts, curve)
}
\arguments{
\item{pts}{A list containing the points as \$lat and \$lon, you may also use
geolocator.}

\item{curve}{The curve to be used for projection.}
}
\value{
Returns a dataframe with vectors pardist (length of orthogonal
projection) and perdist (how far traveled alongst the curve).
}
\description{
Finds curve coordinates of points, given points and a curve it returns the
length of the points orhogonal projection and the distance traveled to the
projection from a given origin on the curve.
}
\section{Side Effects}{
 None.
}
\examples{
\dontrun{       geoplot(my.curve)     # Plot curve and initialize plot.
       geocurve(geolocator(),my.curve)         # Mark points.
}
}
\seealso{
\code{\link{geocurve}}, \code{\link{geolocator}}.
}

