% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/bfse.R
\name{bfse}
\alias{bfse}
\title{Computation of standard errors for Bayes factors}
\usage{
bfse(pargrid, runs, bfsize1 = 0.8, nbatch1 = 0.5, nbatch2 = 0.5,
  method = c("RL", "MW"), bvmethod = c("Standard", "TukeyHanning",
  "Bartlett"), reference = 1, transf = c("no", "mu", "wo"))
}
\arguments{
\item{pargrid}{A data frame with components "linkp", "phi", "omg",
"kappa". Each row gives a combination of the parameters to
compute the new standard errors.}

\item{runs}{A list with outputs from the function
\code{\link{mcsglmm}} or \code{\link{mcstrga}}.}

\item{bfsize1}{A scalar or vector of the same length as
\code{runs} with all integer values or all values in (0, 1]. How
many samples (or what proportion of the sample) to use for
estimating the Bayes factors at the first stage. The remaining
sample will be used for estimating the standard errors in the
second stage. Setting it to 1 will perform only the first stage.}

\item{nbatch1}{A scalar or vector of the same length as
\code{runs}. All values must be integers or less than 1. This is
used for calculating how many batches to split each of the
sample in runs for the calculation of the Bayes factors standard
errors for the parameters corresponding to \code{runs}.}

\item{nbatch2}{A scalar or vector of the same length as
\code{runs}. All values must be integers or less than 1. This is
used for calculating how many batches to split each of the
sample in runs for the calculation of the Bayes factors standard
errors for the parameters corresponding to \code{pargrid}.}

\item{method}{Which method to use to calculate the Bayes factors:
Reverse logistic or Meng-Wong.}

\item{bvmethod}{Which method to use for the calculation of the
batch variance. The standard method splits to disjoint batches.
The second and third method use the spectral variance method
with different lag windows.}

\item{reference}{Which model goes in the denominator.}

\item{transf}{Whether to use a transformed sample for the
computations. If \code{"no"} or \code{FALSE}, it doesn't. If
\code{"mu"} or \code{TRUE}, it uses the samples for the mean. If
\code{"wo"} it uses an alternative transformation. The latter
can be used only for the families indicated by
\code{.geoBayes_models$haswo}.}
}
\value{
A list with components
\itemize{
\item \code{pargrid} The inputted pargrid augmented with the computed standard
errors.
\item \code{bfEstimate} The estimates of the Bayes factors
\item \code{bfSigma} The covariance matrix for the Bayes factors
estimates.
}
}
\description{
Compute the standard errors for the Bayes factors estimates.
}
\details{
Uses the batch means method to compute the standard errors for
Bayes factors.
}
\references{
Roy, V., Tan, A. and Flegal, J. (2018). Estimating
  standard errors for importance sampling estimators with multiple
  Markov chains, Statistica Sinica, 28 1079-1101.
}
