% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/SpcList-Methods.R
\docType{methods}
\name{spc.data2header,list-method}
\alias{spc.data2header,list-method}
\title{Populate fields of header slot using data from data slot}
\usage{
\S4method{spc.data2header}{list}(object, dataname, headerfield,
  compress = TRUE, ...)
}
\arguments{
\item{object}{\code{SpcList} object}

\item{dataname}{A character object specifying the name of @data column to be used}

\item{headerfield}{A character object specifying the name of the @header field to be changed}

\item{compress}{TRUE or FALSE}

\item{...}{arguments to be passed to or from methods. See help of \code{\link{spc.data2header}}.}
}
\value{
object of class \code{SpcList}
}
\description{
Populates a field of @header with a column data from @data slot.
}
\details{
This function extracts data from a column of the @data slot (specified by dataname)  
and creates a new @header field with it. If headerfield is not provided, the name 
of the new header field will be the same as dataname. 
The name of the new header field can be overwritten by providing headerfield.
If all the incoming data rows (dataname) are the same, information put into the header 
can be compressed by selecting compress=TRUE (default is FALSE). This would take only the first element 
from the @data column.
}
\examples{
sp=spc.example_spectra()
BL=spc.makeSpcList(sp,"CAST")
BL[[1]]@header
 BL[[1]]=spc.data2header(BL[[1]],"CAST","ProjectCast")
BL[[1]]@header
BL[[1]]$CAST=rep(33, nrow( BL[[1]]))
BL[[1]]=spc.data2header(BL[[1]],"CAST","ProjectCast", compress=TRUE)
BL[[1]]@header

}
