% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/RcppExports.R
\name{calcSFGCMBelongMatrix}
\alias{calcSFGCMBelongMatrix}
\title{Calculate the generalized membership matrix (spatial version)}
\usage{
calcSFGCMBelongMatrix(centers, data, wdata, m, alpha, beta, sigmas, wsigmas)
}
\arguments{
\item{centers}{A matrix representing the centers of the clusters with p
columns and k rows}

\item{data}{A matrix representing the observed data with n rows and p columns}

\item{wdata}{A matrix representing the lagged observed data with n rows
and p columns}

\item{m}{A float representing the fuzziness degree}

\item{alpha}{A float representing the weight of the space in the analysis (0
is a typical fuzzy-c-mean algorithm, 1 is balanced between the two
dimensions, 2 is twice the weight for space)}

\item{beta}{A float for the beta parameter (control speed convergence and classification crispness)}

\item{sigmas}{A numeric vector for calculating the robust version of the FCM. Filled with ones
if the classical version is required}

\item{wsigmas}{Same as sigmas, but calculated on the spatially lagged dataset}
}
\value{
A n * k matrix representing the belonging probabilities of each
  observation to each cluster
}
\description{
Calculate the generalized membership matrix (spatial version)
}
\keyword{internal}
