% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/get_zipcodes.R
\name{get_zipcodes}
\alias{get_zipcodes}
\title{Get Finnish zip code (multi)polygons for different years.}
\usage{
get_zipcodes(year = 2022, extend_to_sea_areas = FALSE)
}
\arguments{
\item{year}{A numeric for year of the zipcodes. Years available 2015-2022.}

\item{extend_to_sea_areas}{A logical. Extend the data to show also the sea areas.}
}
\value{
sf object
}
\description{
Thin wrapper around Finnish zip code areas provided by
\href{https://www.tilastokeskus.fi/tup/karttaaineistot/postinumeroalueet.html}{Statistics Finland}.
}
\examples{
 \dontrun{
 f <- get_zipcodes(year=2022)
 plot(f)
 }

}
\author{
Markus Kainu \href{mailto:markus.kainu@kela.fi}{markus.kainu@kela.fi}, Joona Lehtomäki \href{mailto:joona.lehtomaki@iki.fi}{joona.lehtomaki@iki.fi}
}
