% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/acs_5yr_geo.R
\name{as_GeoPackage}
\alias{as_GeoPackage}
\alias{as_GeoPackage.acs_5yr_geo}
\title{Save as \code{GeoPackage}}
\usage{
as_GeoPackage(geo, dir, name)

\method{as_GeoPackage}{acs_5yr_geo}(geo, dir = NULL, name = NULL)
}
\arguments{
\item{geo}{An \code{acs_5yr_geo} object.}

\item{dir}{A string.}

\item{name}{A string, file name.}
}
\value{
A string, file name.
}
\description{
Save the data layer (geographic information layer), the metadata layer and the
data source description layer in a file in \code{GeoPackage} format to be able to
work with other tools.
}
\details{
The \code{GeoPackage} format only allows defining a maximum of 1998 columns. If the
number of variables and columns in the geographic layer exceeds this number,
it cannot be saved in this format.
}
\examples{

act <- anrc_2021_x01 |>
  select_report(report = "B01002-Median Age By Sex")

geo <- act |>
  as_acs_5yr_geo()

dir <- tempdir()
file <- geo |>
  as_GeoPackage(dir)

}
\seealso{
Other data exploitation and export functions: 
\code{\link{as_acs_5yr_geo}()},
\code{\link{as_flat_table}()},
\code{\link{as_star_database}()},
\code{\link{get_metadata}()},
\code{\link{set_metadata}()}
}
\concept{data exploitation and export functions}
