% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/get_rasters.R
\name{crops_rast}
\alias{crops_rast}
\title{Get sum of rasters for individual crops}
\usage{
crops_rast(crop_names)
}
\arguments{
\item{crop_names}{A named list of source along with crop names}
}
\value{
SpatRaster. Raster object which is sum of all the individual crop raster
}
\description{
Takes crop names and returns raster object which is sum of raster of individual crops.
Currently, only supports crops listed in
\code{\link[geodata:crop_monfreda]{geodata::monfredaCrops()}}, \code{\link[geodata:crop_spam]{geodata::spamCrops()}}
If crop is present in multiple sources, then their mean is calculated.
}
\examples{
\donttest{
crops_rast(list(monfreda = c("wheat", "barley"), mapspam = c("wheat", "potato")))
}
}
