% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/gstar.R
\name{gstar_i}
\alias{gstar_i}
\title{Compute Standardized Getis Ord G*i}
\usage{
gstar_i(shp, adj, wts, spatial_mat)
}
\arguments{
\item{shp}{sf data frame. Optional if adj or spatial_mat provided.}

\item{adj}{zero indexed adjacency list. Optional if shp or spatial_mat provided.}

\item{wts}{Required. Numeric vector with weights to use for Moran's I.}

\item{spatial_mat}{matrix of spatial weights. Optional if shp or adj provided.}
}
\value{
vector of G*i scores
}
\description{
Returns the Getis Ord G*i in standardized form.
}
\examples{
library(dplyr)
data("checkerboard")
checkerboard <- checkerboard \%>\% mutate(m = as.numeric((id+i) \%\% 2 == 0))
gstar_i(shp = checkerboard, wts = checkerboard$m)

}
\concept{spatcorr}
