% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/FimsUtils.R
\name{querySanger}
\alias{querySanger}
\title{Query Sanger sequences directly from the GEOME database}
\usage{
querySanger(locus, projects = list(), expeditions = list(),
  query = "")
}
\arguments{
\item{locus}{the locus to fetch. list of markers can be found by calling `listLoci()`}

\item{projects}{list of projects to include in the query. The default is all projects}

\item{expeditions}{Only applicable if projects are specified. list of expeditions to include in the query. The default is all expeditions}

\item{query}{FIMS Query DSL \url{http://fims.readthedocs.io/en/latest/fims/query.html} query string.
Ex. 'yearCollected >= 2017 and country = "Indonesia"'}
}
\value{
a DNAbin object, which is a fairly standard form for storing DNA data in binary format. It will also download
a FASTA-formatted file to your working directory.
}
\description{
For Sanger sequence data (typically of mitochondrial origin), it is possible to store the sequence directly within GEOME.
`querySanger()` allows you to download this sequence data into a DNAbin object, as well as to your working directory as a
FASTA-formatted file.
}
\examples{
\dontrun{
data <- querySanger(
    locus = 'CYB', projects=list(1),
    expeditions=list("acaach_CyB_JD", "acajap_CyB_JD"),
    query="yearCollected >= 2008")
 
data <- querySanger(locus = 'CO1', query = "genus = Linckia AND specificEpithet = laevigata" )
}
}
