% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/ISOSecurityConstraints.R
\docType{class}
\name{ISOSecurityConstraints}
\alias{ISOSecurityConstraints}
\title{ISOSecurityConstraints}
\format{\code{\link{R6Class}} object.}
\usage{
ISOSecurityConstraints
}
\value{
Object of \code{\link{R6Class}} for modelling an ISO SecurityConstraints
}
\description{
ISOSecurityConstraints
}
\section{Fields}{

\describe{
\item{\code{classification}}{}

\item{\code{userNote}}{}

\item{\code{classificationSystem}}{}

\item{\code{handlingDescription}}{}
}}
\section{Methods}{

\describe{
 \item{\code{new(xml)}}{
   This method is used to instantiate an ISOSecurityConstraints
 }
 \item{\code{setClassification(classification)}}{
   Adds a classification, as object of class "character" or class \code{ISOClassification}.
   If an object of class "character" is specified, it must match the accepted
   values given by \code{ISOClassification$values()}.
 }
 \item{\code{setUserNote(userNote)}}{
   Sets a user note as object of class "character"
 }
 \item{\code{setClassificationSystem(classificationSystem)}}{
   Sets a classification system as object of class "character"
 }
 \item{\code{setHandlingDescription(handlingDescription)}}{
   Sets a handling description as object of class "character"
 }
}
}
\examples{
#create object
   md <- ISOSecurityConstraints$new()
   md$setClassification("secret")
   md$setUserNote("ultra secret")
   md$setClassificationSystem("no classification in particular")
   md$setHandlingDescription("description")

   xml <- md$encode()
}
\author{
Emmanuel Blondel <emmanuel.blondel1@gmail.com>
}
\references{
ISO 19115:2003 - Geographic information -- Metadata
}
\keyword{ISO}
\keyword{constraints}
\keyword{security}

