% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/gt_pull.R
\name{gt_pull}
\alias{gt_pull}
\title{Extract a single column from a geometric object}
\usage{
gt_pull(obj, var)
}
\arguments{
\item{obj}{[\code{geometric object(1)}]\cr the object to pull a column from.}

\item{var}{[\code{character(1)}]\cr name of the variable to pull.}
}
\value{
vector of the column specified in \code{var}.
}
\description{
This function allows to extract a specific column from any geometric object
for which all required getters are available and thus reflects the base
function \code{$}.
}
\details{
This function searches for \code{var} by first looking in the
  groups, then the features and finally the points of \code{obj}. This
  results always in an output that is limited to the unique cases of
  \code{var}. In case you want the explicit values of, for instance,
  \code{fid} in \code{obj@points}, you have to extract points and then use
  \code{\link[dplyr]{pull}} on the result.
}
\examples{
# pull values from a geom (there are two features, thus two values) ...
gt_pull(gtGeoms$point, "fid")

# pull from a Raster* with RAT
gt_pull(gtGeoms$grid$categorical, "cover")

# pull from an sf-object
gt_pull(gtSF$point, "a")
}
\seealso{
Other geometry tools: 
\code{\link{gt_filter}()},
\code{\link{gt_locate}()},
\code{\link{gt_reflect}()},
\code{\link{gt_rotate}()},
\code{\link{gt_scale}()},
\code{\link{gt_skew}()},
\code{\link{gt_stretch}()},
\code{\link{gt_translate}()}
}
\concept{geometry tools}
