\name{morphol.disparity}
\alias{morphol.disparity}
\title{Morphological disparity for one or more groups of specimens}
\usage{
morphol.disparity(A, groups, iter = 999)
}
\arguments{
  \item{A}{A matrix (n x [p x k]) or 3D array (p x k x n)
  containing GPA-aligned coordinates for a set of
  specimens}

  \item{groups}{A factor defining groups}

  \item{iter}{Number of iterations for permutation test}
}
\value{
Function returns a list with the following components:
\item{Disp.obs}{A matrix of Procrustes variance for each
group} \item{Prob.Dist}{A matrix of pairwise significance
levels based on permutation}
}
\description{
Function estimates morphological disparity and performs
pairwise comparisons among groups.
}
\details{
The function estimates morphological disparity and performs
pairwise comparisons to identify differences between
groups. The function takes as input GPA-aligned shape data
[e.g., \code{\link{gpagen}}] and a grouping factor, and
estimates disparity as the Procrustes variance for each
group, which is the sum of the diagonal elements of the
group covariance matrix (e.g., Zelditch et al. 2012). The
group Procrustes variances are used as test values, and
these are then statistically evaluated through permutation,
where the rows of the shape matrix are randomized relative
to the grouping variable. The function can be used to
obtain disparity for the whole dataset by using a dummy
group factor assigning all specimens to one group, in which
case only Procrustes variance is returned.
}
\examples{
data(plethodon)
Y.gpa<-gpagen(plethodon$land)    #GPA-alignment
morphol.disparity(Y.gpa$coords, groups=plethodon$site, iter = 99)
}
\author{
Emma Sherratt
}
\references{
Zelditch, M. L., D. L. Swiderski, H. D. Sheets, and W. L.
Fink. 2012. Geometric morphometrics for biologists: a
primer. 2nd edition. Elsevier/Academic Press, Amsterdam.
}
\keyword{analysis}

