% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/utils.R
\name{removeoutlier}
\alias{removeoutlier}
\title{Removing outliers.}
\usage{
removeoutlier(x, coef = 2.5)
}
\arguments{
\item{x}{A vector of a variable}

\item{coef}{A number of the times of standard deviation. Default is \code{2.5}.}
}
\value{
Location of outliers in the vector
}
\description{
Function for removing outliers.
}
\examples{
data("zn")
# log-transformation
hist(zn$Zn)
zn$Zn <- log(zn$Zn)
hist(zn$Zn)
# remove outliers
k <- removeoutlier(zn$Zn, coef = 2.5)
k

}
