% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/transformations.R
\name{clr}
\alias{clr}
\title{centred logratio transformation}
\usage{
clr(dat, inverse = FALSE)
}
\arguments{
\item{dat}{an \code{n x m} matrix}

\item{inverse}{logical. If \code{TRUE}, applies the inverse clr
tranformation}
}
\value{
an \code{n x m} matrix
}
\description{
Maps compositional data from an n-dimensional simplex
    to an n-dimensional Euclidean space with Aitchison's centred
    logratio transformation.
}
\examples{
xyz <- rbind(c(0.03,99.88,0.09),
             c(70.54,25.95,3.51),
             c(72.14,26.54,1.32))
colnames(xyz) <- c('a','b','c')
rownames(xyz) <- 1:3
pc <- prcomp(clr(xyz))
biplot(pc)
}
